---
generated_at: 2026-01-22 12:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：173-リポジトリ設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **EE版保護ブランチ機能**：render_if_existsの実装を確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/groups/settings/repository/show.html.haml`（行1-15）
- E-02: `app/controllers/groups/settings/repository_controller.rb`（行1-78）
- E-03: `config/routes/group.rb`（行56-58）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行230）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行174）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/groups/:group_id/-/settings/repository` | E-03（行56） | ○ |
| C-02 | create_deploy_tokenアクション | E-02（行19-45）, E-03（行57） | ○ |
| C-03 | レイアウトは group_settings | E-02（行6） | ○ |
| C-04 | skip_cross_project_access_check を使用 | E-02（行7） | ○ |
| C-05 | create_deploy_token権限でデプロイトークンセクション表示 | E-01（行5-7）, E-02（行10） | ○ |
| C-06 | admin_group権限でデフォルトブランチ表示 | E-01（行9-10） | ○ |
| C-07 | change_push_rules権限でプッシュルール表示 | E-01（行13-14） | ○ |
| C-08 | デプロイトークン作成時のパラメータ一覧 | E-02（行59-70） | ○ |
| C-09 | Groups::DeployTokens::CreateService でトークン作成 | E-02（行20） | ○ |
| C-10 | 成功時のフラッシュメッセージ | E-02（行31） | ○ |
| C-11 | JSON形式でAPI::Entities::DeployTokenWithTokenを返却 | E-02（行27） | ○ |
| C-12 | 失敗時にエラーメッセージをフラッシュ表示 | E-02（行40-41） | ○ |
| C-13 | before_action で authorize_access! | E-02（行9） | ○ |
| C-14 | define_deploy_token_variables で変数設定 | E-02（行53-57） | ○ |
| C-15 | @deploy_tokens = @group.deploy_tokens.active | E-02（行54） | ○ |
| C-16 | feature_category は :continuous_delivery | E-02（行16） | ○ |
| C-17 | urgency は :low | E-02（行17） | ○ |
| C-18 | カテゴリは「グループ設定」 | E-05 | ○ |
| C-19 | 機能No.25（保護ブランチ）に関連 | E-04 | ○ |
| C-20 | EE版で保護ブランチが追加される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-20のEE版保護ブランチ**: `render_if_exists`の呼び出しは確認できるが、EE版のファイル実体は確認していない
  - 候補: `ee/app/views/groups/settings/repository/_protected_branches.html.haml`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - コントローラー、ビュー、ルーティングの整合性は確認済み
- **1: 中リスク** - EE版固有の機能は確認対象外

## 6) レビュアーチェックリスト（最小）
- [ ] EE版の保護ブランチパーシャルの存在確認
- [ ] デプロイトークン作成サービスの詳細実装確認
- [ ] 共有パーシャル `shared/deploy_tokens/_index` の内容確認
- [ ] プッシュルールパーシャルの内容確認
