---
generated_at: 2026-01-22 12:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：174-CI/CD設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **EE版保護環境機能**：render_if_existsの実装を確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/groups/settings/ci_cd/show.html.haml`（行1-55）
- E-02: `app/controllers/groups/settings/ci_cd_controller.rb`（行1-135）
- E-03: `config/routes/group.rb`（行45-50）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行231）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行175）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/groups/:group_id/-/settings/ci_cd` | E-03（行45） | ○ |
| C-02 | show, updateアクションがある | E-03（行45）, E-02（行23, 30） | ○ |
| C-03 | update_auto_devopsアクション | E-03（行47）, E-02（行42） | ○ |
| C-04 | レイアウトは group_settings | E-02（行6） | ○ |
| C-05 | admin_cicd_variables権限で変数セクション表示 | E-01（行21-28）, E-02（行75-81） | ○ |
| C-06 | admin_runners権限でRunnerセクション表示 | E-01（行30-38）, E-02（行75-81） | ○ |
| C-07 | admin_group権限でAuto DevOpsセクション表示 | E-01（行40-51） | ○ |
| C-08 | Groups::UpdateServiceで更新 | E-02（行113-114） | ○ |
| C-09 | Groups::AutoDevopsServiceでAuto DevOps更新 | E-02（行109-110） | ○ |
| C-10 | 成功時メッセージ "Group CI/CD settings were successfully updated." | E-02（行32） | ○ |
| C-11 | Auto DevOps成功時メッセージ | E-02（行44） | ○ |
| C-12 | 監査ログが記録される | E-02（行27, 56-72） | ○ |
| C-13 | ci_variables_pagesフィーチャーフラグがプッシュされる | E-02（行18） | ○ |
| C-14 | @entity = :group が設定される | E-02（行24） | ○ |
| C-15 | @variable_limit でグループ変数の上限取得 | E-02（行25） | ○ |
| C-16 | update_group_paramsでmax_artifacts_size等を許可 | E-02（行117-122） | ○ |
| C-17 | feature_category は :continuous_integration | E-02（行15） | ○ |
| C-18 | urgency は :low | E-02（行21） | ○ |
| C-19 | カテゴリは「グループ設定」 | E-05 | ○ |
| C-20 | 機能No.50（CI変数管理）に関連 | E-04 | ○ |
| C-21 | 変数は present(current_user:) でラップ | E-02（行89-92） | ○ |
| C-22 | EE版で保護環境セクションが追加される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-22のEE版保護環境**: `render_if_exists`の呼び出しは確認できるが、EE版のファイル実体は確認していない
  - 候補: `ee/app/views/groups/settings/ci_cd/_protected_environments.html.haml`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - コントローラー、ビュー、ルーティングの整合性は確認済み
- **0: 低リスク** - 監査ログの記録も確認済み
- **1: 中リスク** - EE版固有の機能は確認対象外

## 6) レビュアーチェックリスト（最小）
- [ ] EE版の保護環境パーシャルの存在確認
- [ ] ci/variables/_index パーシャルの詳細確認
- [ ] groups/runners/_settings パーシャルの内容確認
- [ ] Auto DevOpsサービスの詳細実装確認
