---
generated_at: 2026-01-22 12:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：176-インテグレーション一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/groups/settings/integrations/index.html.haml`（行1-13）
- E-02: `app/controllers/groups/settings/integrations_controller.rb`（行1-34）
- E-03: `config/routes/group.rb`（行71-76）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行233）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行177）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/groups/:group_id/-/settings/integrations` | E-03（行71） | ○ |
| C-02 | index, edit, updateアクションがある | E-03（行71）, E-02（行14, 20） | ○ |
| C-03 | testアクション | E-03（行73） | ○ |
| C-04 | resetアクション | E-03（行74） | ○ |
| C-05 | レイアウトは group_settings | E-02（行12） | ○ |
| C-06 | admin_integrations権限が必要 | E-02（行8） | ○ |
| C-07 | find_or_initialize_all_non_project_specificでインテグレーション取得 | E-02（行15-16） | ○ |
| C-08 | タイトル降順でソート | E-02（行17） | ○ |
| C-09 | feature_category は :integrations | E-02（行10） | ○ |
| C-10 | 共通パーシャル shared/integrations/_index を使用 | E-01（行12） | ○ |
| C-11 | PageHeadingComponentでヘッダー表示 | E-01（行6-10） | ○ |
| C-12 | ヘルプリンクを含む説明文 | E-01（行8-9） | ○ |
| C-13 | カテゴリは「グループ設定」 | E-05 | ○ |
| C-14 | 機能No.95（Slack連携）に関連 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠が確認できました）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張に根拠が確認できている

## 6) レビュアーチェックリスト（最小）
- [ ] 共有パーシャル shared/integrations/_index の内容確認
- [ ] Integrations::Actions concernの実装確認
- [ ] 実際の画面表示とドキュメント内容が一致するか確認
