---
generated_at: 2026-01-22 12:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：177-アクセストークン一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **AccessTokensActions Concernの詳細**: 共通アクションの実装確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/groups/settings/access_tokens/index.html.haml`（行1-60）
- E-02: `app/controllers/groups/settings/access_tokens_controller.rb`（行1-30）
- E-03: `config/routes/group.rb`（行60-68）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行234）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行178）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/groups/:group_id/-/settings/access_tokens` | E-03（行60） | ○ |
| C-02 | index, createアクション | E-03（行60） | ○ |
| C-03 | revoke, rotateアクション | E-03（行62-63） | ○ |
| C-04 | inactiveアクション | E-03（行66-67） | ○ |
| C-05 | レイアウトは group_settings | E-02（行9） | ○ |
| C-06 | feature_category は :system_access | E-02（行10） | ○ |
| C-07 | alias_method :resource, :group | E-02（行12） | ○ |
| C-08 | GroupAccessTokenSerializerでシリアライズ | E-02（行20-22） | ○ |
| C-09 | GroupAccessTokens::RotateServiceでローテーション | E-02（行24-26） | ○ |
| C-10 | SettingsSectionComponentで説明表示 | E-01（行7） | ○ |
| C-11 | create_resource_access_tokens権限で作成可否判定 | E-01（行10, 32, 37） | ○ |
| C-12 | デフォルトアクセスレベルはGuest | E-01（行46） | ○ |
| C-13 | CrudComponentでアクティブトークン一覧 | E-01（行25-52） | ○ |
| C-14 | CrudComponentで非アクティブトークン一覧 | E-01（行54-59） | ○ |
| C-15 | トークンなしメッセージ | E-01（行52, 59） | ○ |
| C-16 | カテゴリは「グループ設定」 | E-05 | ○ |
| C-17 | 機能No.81（個人アクセストークン）に関連 | E-04 | ○ |
| C-18 | AccessTokensActions Concernの共通アクション | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-18のAccessTokensActions**: Concernファイルを直接読み込んでいないため詳細は未確認
  - 候補: `app/controllers/concerns/access_tokens_actions.rb`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - コントローラーとビューの整合性は確認済み
- **1: 中リスク** - Concernの詳細実装は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] AccessTokensActions Concernの実装を確認
- [ ] RenderAccessTokens Concernの実装を確認
- [ ] shared/access_tokens/_form パーシャルの内容確認
- [ ] Vue.jsトークンテーブルコンポーネントの確認
