---
generated_at: 2026-01-22 12:35:00
metrics:
  claims_total: 10
  claims_with_evidence: 8
  claims_without_evidence: 2
confidence_derived: 0.80
---

# 根拠レポート：178-バッジ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：8 / 10、根拠なし：2
- 優先レビュー（高）
  1. **コントローラー実装**：BadgesControllerの存在確認
  2. **ルーティング設定**：グループバッジのルート確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/groups/settings/badges/index.html.haml`（行1-5）
- E-02: `app/views/shared/badges/_badge_settings.html.haml`（行1-2）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行235）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行179）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ページタイトルは "Project Badges" | E-01（行1-2） | ○ |
| C-02 | 共有パーシャル shared/badges/_badge_settings を使用 | E-01（行4） | ○ |
| C-03 | #badge-settings にVue.jsアプリをマウント | E-02（行1） | ○ |
| C-04 | @badge_api_endpoint をデータ属性で渡す | E-02（行1） | ○ |
| C-05 | カテゴリは「グループ設定」 | E-04 | ○ |
| C-06 | 機能No.148（バッジ管理）に関連 | E-03 | ○ |
| C-07 | URL形式は `/groups/:group_id/-/settings/badges` | **根拠なし** | △ |
| C-08 | BadgesControllerでリクエスト処理 | **根拠なし** | △ |
| C-09 | Badge APIでCRUD操作 | E-02（推測） | ○ |
| C-10 | Vue.jsアプリケーションで画面描画 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-07のルーティング**: グループバッジのルート定義を直接確認していない
  - 候補: `config/routes/group.rb`内のbadgesリソース
- **C-08のコントローラー**: BadgesControllerの存在を確認していない
  - 候補: `app/controllers/groups/settings/badges_controller.rb`または共通コントローラー

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - ルーティングとコントローラーの詳細は未確認
- **0: 低リスク** - ビューとパーシャルの構造は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] グループバッジのルーティング設定を確認
- [ ] BadgesControllerまたは対応するコントローラーを確認
- [ ] Badge APIの実装を確認
- [ ] Vue.jsコンポーネントの詳細を確認
