---
generated_at: 2026-01-22 12:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：179-アプリケーション一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **OauthApplications Concernの詳細**: 共通処理の実装確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/groups/settings/applications/index.html.haml`（行1-11）
- E-02: `app/controllers/groups/settings/applications_controller.rb`（行1-84）
- E-03: `config/routes/group.rb`（行82-84）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行236）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行180）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/groups/:group_id/-/settings/applications` | E-03（行82） | ○ |
| C-02 | index, create, show, edit, update, destroyアクション | E-02, E-03 | ○ |
| C-03 | renewアクション | E-03（行83）, E-02（行45-52） | ○ |
| C-04 | authorize_admin_group!で権限チェック | E-02（行8） | ○ |
| C-05 | load_scopesでスコープ読み込み | E-02（行10） | ○ |
| C-06 | Applications::CreateServiceでアプリ作成 | E-02（行23） | ○ |
| C-07 | keyset_paginateでページネーション | E-02（行64） | ○ |
| C-08 | feature_category は :system_access | E-02（行12） | ○ |
| C-09 | ページタイトル "Group applications" | E-01（行1） | ○ |
| C-10 | page_bundles/settings スタイル使用 | E-01（行2） | ○ |
| C-11 | 共有パーシャル shared/doorkeeper/applications/_index を使用 | E-01（行5-10） | ○ |
| C-12 | renewでシークレット更新しJSON返却 | E-02（行45-52） | ○ |
| C-13 | Authn::OauthApplication.new でフォーム初期化 | E-02（行68） | ○ |
| C-14 | application_paramsでowner, organizationを設定 | E-02（行75-79） | ○ |
| C-15 | カテゴリは「グループ設定」 | E-05 | ○ |
| C-16 | 機能No.88（OAuth2プロバイダ）に関連 | E-04 | ○ |
| C-17 | OauthApplications Concern をinclude | E-02（行6） | ○ |
| C-18 | OauthApplications Concernの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-18のOauthApplications Concern**: Concernファイルを直接読み込んでいないため詳細は未確認
  - 候補: `app/controllers/concerns/oauth_applications.rb`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - コントローラーとビューの整合性は確認済み
- **1: 中リスク** - Concernの詳細実装は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] OauthApplications Concernの実装を確認
- [ ] shared/doorkeeper/applications/_index パーシャルの内容確認
- [ ] Applications::CreateService の実装確認
- [ ] Authn::OauthApplication モデルの確認
