---
generated_at: 2026-01-22 12:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：180-アプリケーション詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **共有パーシャルの詳細**: _show.html.hamlの内容確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/groups/settings/applications/show.html.haml`（行1-11）
- E-02: `app/controllers/groups/settings/applications_controller.rb`（行1-84）
- E-03: `config/routes/group.rb`（行82-84）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行237）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行181）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/groups/:group_id/-/settings/applications/:id` | E-03（行82） | ○ |
| C-02 | showアクションで詳細表示 | E-02（行18）, E-03 | ○ |
| C-03 | destroyアクションでアプリ削除 | E-02（行55-59） | ○ |
| C-04 | renewアクションでシークレット再生成 | E-02（行45-52） | ○ |
| C-05 | set_applicationで@applicationを設定 | E-02（行71-72） | ○ |
| C-06 | パンくずリストに一覧リンク追加 | E-01（行1） | ○ |
| C-07 | ページタイトルは "Group application: {name}" | E-01（行3, 5） | ○ |
| C-08 | PageHeadingComponentでタイトル表示 | E-01（行5） | ○ |
| C-09 | 共有パーシャル shared/doorkeeper/applications/_show を使用 | E-01（行6-10） | ○ |
| C-10 | edit_path を渡す | E-01（行7） | ○ |
| C-11 | delete_path を渡す | E-01（行8） | ○ |
| C-12 | index_path を渡す | E-01（行9） | ○ |
| C-13 | renew_path を渡す | E-01（行10） | ○ |
| C-14 | 機能No.88（OAuth2プロバイダ）に関連 | E-04 | ○ |
| C-15 | 共有パーシャルの詳細な表示内容 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-15の共有パーシャル詳細**: `shared/doorkeeper/applications/_show.html.haml`の内容を直接確認していない
  - 候補: `app/views/shared/doorkeeper/applications/_show.html.haml`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - コントローラーとビューの整合性は確認済み
- **1: 中リスク** - 共有パーシャルの詳細内容は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] shared/doorkeeper/applications/_show パーシャルの内容確認
- [ ] renew_secret メソッドの実装確認
- [ ] 実際の画面表示とドキュメント内容が一致するか確認
