---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：181-アプリケーション編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **メッセージID体系**：コード内で確認できるI18nキーと異なる可能性
  2. **スコープの詳細一覧**：利用可能なスコープの完全なリストは別途確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/groups/settings/applications_controller.rb`
- E-02: `app/views/groups/settings/applications/edit.html.haml`
- E-03: `app/views/shared/doorkeeper/applications/_form.html.haml`
- E-04: `app/models/authn/oauth_application.rb`
- E-05: `config/routes/group.rb`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | グループ管理者権限が必要 | E-01 (行8: authorize_admin_group!) | ○ |
| C-02 | URLパターンがgroups/:group_id/-/settings/applications/:id/edit | E-05 (行82-84) | ○ |
| C-03 | editアクションが存在する | E-01 (行20) | ○ |
| C-04 | updateアクションが存在する | E-01 (行36-43) | ○ |
| C-05 | フォームにname項目がある | E-03 (行7-8) | ○ |
| C-06 | フォームにredirect_uri項目がある | E-03 (行10-12) | ○ |
| C-07 | フォームにconfidential項目がある | E-03 (行17-19) | ○ |
| C-08 | フォームにscopes項目がある | E-03 (行21-23) | ○ |
| C-09 | 成功時にフラッシュメッセージを表示 | E-01 (行38-39) | ○ |
| C-10 | 更新成功時に詳細画面へリダイレクト | E-01 (行38) | ○ |
| C-11 | 更新失敗時に編集画面を再表示 | E-01 (行42) | ○ |
| C-12 | 共有フォームテンプレートを使用 | E-02 (行4) | ○ |
| C-13 | ページタイトルが"Edit group application" | E-02 (行3) | ○ |
| C-14 | OAuthアプリケーションモデルがorganizationに属する | E-04 (行7) | ○ |
| C-15 | 機能No.88がOAuth2プロバイダ | E-06 | ○ |
| C-16 | oauth_applicationsテーブルを更新 | E-01, E-04 | ○ |
| C-17 | メッセージIDがMSG-001,002,003 | **根拠なし** | △ |
| C-18 | スコープの完全なリスト | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- メッセージID体系はドキュメント作成時に付与したものであり、実際のI18nキーとは異なる
  - 候補：`config/locales/en.yml` / `locale/doorkeeper.en.yml`を確認
- 利用可能なスコープの完全なリストは `load_scopes` メソッドで動的に取得されるため、別途確認が必要
  - 候補：`Doorkeeper.config.scopes` / `app/models/authn/oauth_application.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面フローとデータ更新処理
- 0: 低リスク - 権限チェックが実装されている
- 1: 中リスク - スコープ設定の詳細は動的に決定されるため、実行時の挙動確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] コントローラーの権限チェック（authorize_admin_group!）が適切か確認
- [ ] フォームのバリデーションルールがモデルで定義されているか確認
- [ ] リダイレクト先のパスが正しいか確認
- [ ] 機密アプリケーション設定の説明文が適切か確認
