---
generated_at: 2026-01-22 10:32:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：182-組織一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **GraphQLクエリのスキーマ詳細**：取得フィールドの完全なリストは別途確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/organizations/organizations_controller.rb`
- E-02: `app/controllers/organizations/application_controller.rb`
- E-03: `app/views/organizations/organizations/index.html.haml`
- E-04: `app/assets/javascripts/organizations/index/components/app.vue`
- E-05: `app/helpers/organizations/organization_helper.rb`
- E-06: `config/routes/organizations.rb`
- E-07: `app/models/organizations/organization.rb`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが/-/organizationsまたは/o | E-06 (行3, 6) | ○ |
| C-02 | indexアクションが存在する | E-01 (行23) | ○ |
| C-03 | フィーチャーフラグのチェックがある | E-02 (行22-24) | ○ |
| C-04 | Vue.jsでSPAとして実装 | E-03 (行5), E-04 | ○ |
| C-05 | GraphQLでデータ取得 | E-04 (行7, 34-46) | ○ |
| C-06 | ページネーション機能がある | E-04 (行57-72) | ○ |
| C-07 | 新規作成ボタンの権限制御 | E-04 (行22, 82-84), E-05 (行109-114) | ○ |
| C-08 | organization_switching フラグが必要 | E-05 (行112) | ○ |
| C-09 | 組織モデルにユーザー関連がある | E-07 (行48-52) | ○ |
| C-10 | エラーメッセージが定義されている | E-04 (行14-16) | ○ |
| C-11 | DEFAULT_PER_PAGE(20件)を使用 | E-04 (行5) | ○ |
| C-12 | app_dataヘルパーが使用される | E-03 (行5), E-05 (行43-45) | ○ |
| C-13 | ページタイトルがOrganizations | E-03 (行2) | ○ |
| C-14 | 機能No.134が組織管理 | E-08 | ○ |
| C-15 | GraphQLクエリの完全なフィールドリスト | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GraphQLクエリ（currentUserOrganizationsQuery）で取得されるフィールドの完全なリストは、GraphQLスキーマファイルを別途確認する必要がある
  - 候補：`app/graphql/types/organizations/organization_type.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 参照のみの画面であり、データ更新は発生しない
- 0: 低リスク - フィーチャーフラグによる適切なアクセス制御
- 1: 中リスク - GraphQLクエリのパフォーマンス（大量の組織がある場合）

## 6) レビュアーチェックリスト（最小）
- [ ] フィーチャーフラグ（ui_for_organizations, organization_switching）の設定確認
- [ ] GraphQLクエリのパフォーマンス確認（N+1問題等）
- [ ] 空状態時の表示が適切か確認
- [ ] ページネーションの動作確認
