---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：183-組織新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **organization_usersへのオーナー追加タイミング**：GraphQL MutationまたはServiceクラスでの処理詳細を確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/organizations/organizations_controller.rb`
- E-02: `app/controllers/organizations/application_controller.rb`
- E-03: `app/views/organizations/organizations/new.html.haml`
- E-04: `app/assets/javascripts/organizations/new/components/app.vue`
- E-05: `app/helpers/organizations/organization_helper.rb`
- E-06: `app/models/organizations/organization.rb`
- E-07: `config/routes/organizations.rb`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが/-/organizations/new | E-07 (行6) | ○ |
| C-02 | newアクションでauthorize_create_organization!が呼ばれる | E-01 (行25-27) | ○ |
| C-03 | organization_switchingフラグが必要 | E-02 (行27) | ○ |
| C-04 | create_organization権限が必要 | E-02 (行28) | ○ |
| C-05 | Vue.jsでSPAとして実装 | E-03, E-04 | ○ |
| C-06 | GraphQL Mutationで作成 | E-04 (行42-55) | ○ |
| C-07 | 組織名が必須（最大255文字） | E-06 (行54-56) | ○ |
| C-08 | パスが必須（2-255文字） | E-06 (行58-62) | ○ |
| C-09 | パスがユニーク | E-06 (行60) | ○ |
| C-10 | 成功メッセージが表示される | E-04 (行20-21, 63-70) | ○ |
| C-11 | エラーメッセージが定義されている | E-04 (行19) | ○ |
| C-12 | アバターアップロード対応 | E-04 (行49, 53) | ○ |
| C-13 | 成功時に詳細画面へリダイレクト | E-04 (行63) | ○ |
| C-14 | ページタイトルがNew organization | E-04 (行15), E-03 (行2) | ○ |
| C-15 | ヘルプページへのリンクがある | E-04 (行30-32) | ○ |
| C-16 | preview_markdown_pathが使用される | E-05 (行103) | ○ |
| C-17 | 機能No.134が組織管理 | E-08 | ○ |
| C-18 | 作成者がオーナーとして追加される | **根拠なし**（GraphQL Resolver要確認） | △ |

## 4) 不足情報（Unknown / Missing）
- 組織作成時に作成者をオーナーとして`organization_users`に追加する処理は、GraphQL Mutation Resolverまたは対応するServiceクラスで実装されている可能性が高いが、直接のコード確認が必要
  - 候補：`app/graphql/mutations/organizations/create.rb` / `app/services/organizations/create_service.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 権限チェックが適切に実装されている
- 1: 中リスク - パスのユニーク制約違反時のエラーハンドリング
- 1: 中リスク - 大きなアバター画像アップロード時のパフォーマンス

## 6) レビュアーチェックリスト（最小）
- [ ] パスのバリデーションパターンが適切か確認
- [ ] アバターのサイズ・形式制限が適切か確認
- [ ] 作成後のオーナー権限付与が正しく行われるか確認
- [ ] エラー時のユーザーフィードバックが十分か確認
