---
generated_at: 2026-01-22 10:38:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：184-組織詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **OrganizationAssociationCounterの詳細実装**：サービスクラスの具体的なカウント方法を確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/organizations/organizations_controller.rb`
- E-02: `app/views/organizations/organizations/show.html.haml`
- E-03: `app/assets/javascripts/organizations/show/components/app.vue`
- E-04: `app/helpers/organizations/organization_helper.rb`
- E-05: `app/models/organizations/organization.rb`
- E-06: `config/routes/organizations.rb`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが/-/organizations/:organization_path | E-06 (行6) | ○ |
| C-02 | showアクションが存在する | E-01 (行29) | ○ |
| C-03 | authorize_read_organization!が呼ばれる | E-01 (行14) | ○ |
| C-04 | 未認証ユーザーもアクセス可能 | E-01 (行19) | ○ |
| C-05 | Vue.jsでSPAとして実装 | E-02, E-03 | ○ |
| C-06 | organization_show_app_dataでデータを準備 | E-02 (行4), E-04 (行15-23) | ○ |
| C-07 | アバターURLが128pxで取得される | E-04 (行18) | ○ |
| C-08 | description_htmlが使用される | E-04 (行17) | ○ |
| C-09 | association_countsが含まれる | E-04 (行21) | ○ |
| C-10 | groups_and_projects_pathが含まれる | E-04 (行19) | ○ |
| C-11 | users_pathが含まれる | E-04 (行20) | ○ |
| C-12 | 統計カードコンポーネントが使用される | E-03 (行35-40) | ○ |
| C-13 | ページタイトルがOrganization overview | E-02 (行1) | ○ |
| C-14 | 機能No.134が組織管理 | E-07 | ○ |
| C-15 | delegateでdescription等を委譲 | E-05 (行67) | ○ |
| C-16 | OrganizationAssociationCounterの詳細 | **根拠なし**（サービスクラス要確認） | △ |

## 4) 不足情報（Unknown / Missing）
- OrganizationAssociationCounterサービスクラスの具体的な実装内容（カウントのSQL、キャッシュ戦略等）
  - 候補：`app/services/organizations/organization_association_counter.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 参照のみの画面であり、データ更新は発生しない
- 1: 中リスク - 大規模組織での統計カウントのパフォーマンス
- 0: 低リスク - 適切なアクセス制御が実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 公開組織の表示が適切か確認
- [ ] 統計カウントのパフォーマンス確認
- [ ] 組織が存在しない場合の404処理確認
- [ ] description_htmlのサニタイズ確認
