---
generated_at: 2026-01-22 10:41:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：185-組織ユーザー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **アクセスレベル変更のGraphQL Mutation**：具体的なMutation定義を確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/organizations/organizations_controller.rb`
- E-02: `app/controllers/organizations/application_controller.rb`
- E-03: `app/views/organizations/organizations/users.html.haml`
- E-04: `app/assets/javascripts/organizations/users/components/app.vue`
- E-05: `app/helpers/organizations/organization_helper.rb`
- E-06: `config/routes/organizations.rb`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが/-/organizations/:organization_path/users | E-06 (行14) | ○ |
| C-02 | usersアクションが存在する | E-01 (行52-54) | ○ |
| C-03 | authorize_read_organization_user!が呼ばれる | E-01 (行53), E-02 (行35-37) | ○ |
| C-04 | Vue.jsでSPAとして実装 | E-03, E-04 | ○ |
| C-05 | GraphQLでデータ取得 | E-04 (行8, 42-54) | ○ |
| C-06 | ページネーション機能がある | E-04 (行89-109) | ○ |
| C-07 | organization_user_app_dataでデータを準備 | E-03 (行3), E-05 (行47-52) | ○ |
| C-08 | organizationGidが含まれる | E-05 (行49) | ○ |
| C-09 | isLastOwnerフラグがある | E-04 (行9, 73) | ○ |
| C-10 | 役割変更後にキャッシュを更新 | E-04 (行111-139) | ○ |
| C-11 | エラーメッセージが定義されている | E-04 (行28-30) | ○ |
| C-12 | ページタイトルがUsers | E-03 (行1), E-04 (行26) | ○ |
| C-13 | ORGANIZATION_USERS_PER_PAGE定数を使用 | E-04 (行10) | ○ |
| C-14 | バッジ情報を取得 | E-04 (行66) | ○ |
| C-15 | 公開メールを表示 | E-04 (行72) | ○ |
| C-16 | 機能No.134が組織管理 | E-07 | ○ |
| C-17 | アクセスレベル変更のMutation詳細 | **根拠なし**（GraphQL Mutation要確認） | △ |

## 4) 不足情報（Unknown / Missing）
- アクセスレベル変更に使用されるGraphQL Mutationの詳細定義
  - 候補：`app/graphql/mutations/organizations/organization_users/update.rb`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 最後のオーナー変更防止ロジックの正確性
- 1: 中リスク - キャッシュ無効化のタイミングと範囲
- 0: 低リスク - 適切なアクセス制御が実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] read_organization_user権限のスコープ確認
- [ ] 最後のオーナー判定ロジックの確認
- [ ] アクセスレベル変更時の監査ログ確認
- [ ] キャッシュ無効化の動作確認
