---
generated_at: 2026-01-22 10:44:00
metrics:
  claims_total: 19
  claims_with_evidence: 18
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：186-組織グループ・プロジェクト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：18 / 19、根拠なし：1
- 優先レビュー（高）
  1. **user_preferencesのカラム名**：実際のカラム名を確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/organizations/organizations_controller.rb`
- E-02: `app/views/organizations/organizations/groups_and_projects.html.haml`
- E-03: `app/assets/javascripts/organizations/groups_and_projects/components/app.vue`
- E-04: `app/helpers/organizations/organization_helper.rb`
- E-05: `config/routes/organizations.rb`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが/-/organizations/:organization_path/groups_and_projects | E-05 (行13) | ○ |
| C-02 | groups_and_projectsアクションが存在する | E-01 (行50) | ○ |
| C-03 | authorize_read_organization!が呼ばれる | E-01 (行14) | ○ |
| C-04 | 未認証ユーザーもアクセス可能 | E-01 (行19) | ○ |
| C-05 | Vue.jsでSPAとして実装 | E-02, E-03 | ○ |
| C-06 | displayクエリでgroups/projects切替 | E-03 (行54-69) | ○ |
| C-07 | 検索は3文字以上で実行 | E-03 (行37, 157-161) | ○ |
| C-08 | ソートオプションが定義されている | E-03 (行31) | ○ |
| C-09 | userPreferencesUpdate Mutationを使用 | E-03 (行24, 175-186) | ○ |
| C-10 | create_group権限でボタン表示制御 | E-04 (行93) | ○ |
| C-11 | can_create_project?でボタン表示制御 | E-04 (行94) | ○ |
| C-12 | GroupsViewコンポーネントを使用 | E-03 (行5, 62) | ○ |
| C-13 | ProjectsViewコンポーネントを使用 | E-03 (行6, 65) | ○ |
| C-14 | FilteredSearchAndSortを使用 | E-03 (行18, 216-228) | ○ |
| C-15 | ページタイトルがGroups and projects | E-02 (行1), E-03 (行35) | ○ |
| C-16 | 機能No.134が組織管理 | E-06 | ○ |
| C-17 | Vue Routerでクエリパラメータ同期 | E-03 (行123-131, 170-173) | ○ |
| C-18 | 設定更新エラー時Sentryにログ | E-03 (行23, 184) | ○ |
| C-19 | user_preferencesの正確なカラム名 | **根拠なし**（モデル要確認） | △ |

## 4) 不足情報（Unknown / Missing）
- user_preferencesテーブルの `organization_groups_projects_display`、`organization_groups_projects_sort` カラムの存在と型
  - 候補：`app/models/user_preference.rb`、`db/schema.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 参照メインの画面
- 1: 中リスク - 大量のグループ・プロジェクトがある場合のパフォーマンス
- 0: 低リスク - 設定更新エラーはサイレント処理で影響限定的

## 6) レビュアーチェックリスト（最小）
- [ ] グループ一覧とプロジェクト一覧の表示切り替え動作確認
- [ ] 検索の3文字制限のUX確認
- [ ] ソート設定の永続化確認
- [ ] 空状態の表示確認
