---
generated_at: 2026-01-22 10:47:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：187-組織アクティビティ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **EventCollectionの詳細実装**：イベント取得のSQL最適化を確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/organizations/organizations_controller.rb`
- E-02: `app/views/organizations/organizations/activity.html.haml`
- E-03: `app/assets/javascripts/organizations/activity/components/app.vue`
- E-04: `app/helpers/organizations/organization_helper.rb`
- E-05: `config/routes/organizations.rb`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが/-/organizations/:organization_path/activity | E-05 (行12) | ○ |
| C-02 | activityアクションが存在する | E-01 (行31-48) | ○ |
| C-03 | authorize_read_organization!が呼ばれる | E-01 (行14) | ○ |
| C-04 | 未認証ユーザーもアクセス可能 | E-01 (行19) | ○ |
| C-05 | HTML/JSON両対応 | E-01 (行32-47) | ○ |
| C-06 | event_filterが適用される | E-01 (行13) | ○ |
| C-07 | DEFAULT_ACTIVITY_EVENT_LIMIT=20 | E-01 (行9) | ○ |
| C-08 | limit+1で次ページ判定 | E-01 (行36-39, 87-88) | ○ |
| C-09 | visible_to_user?でフィルタリング | E-01 (行41) | ○ |
| C-10 | Events::RenderServiceを使用 | E-01 (行93) | ○ |
| C-11 | EventCollectionを使用 | E-01 (行82-91) | ○ |
| C-12 | organization_activity_app_dataでデータ準備 | E-02 (行5), E-04 (行78-84) | ○ |
| C-13 | イベントタイプ一覧が定義されている | E-04 (行150-180) | ○ |
| C-14 | Vue.jsでSPAとして実装 | E-02, E-03 | ○ |
| C-15 | フィルタードサーチを使用 | E-03 (行9, 133-139) | ○ |
| C-16 | ページタイトルがActivity | E-02 (行1, 3-4) | ○ |
| C-17 | 機能No.136がアクティビティフィード | E-06 | ○ |
| C-18 | EventCollectionの詳細SQL | **根拠なし**（モデル要確認） | △ |

## 4) 不足情報（Unknown / Missing）
- EventCollectionクラスの具体的なSQL実装とパフォーマンス最適化
  - 候補：`app/models/event_collection.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 参照のみの画面
- 1: 中リスク - 大量のイベントがある組織でのパフォーマンス
- 1: 中リスク - visible_to_user?のN+1問題の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] イベントフィルターの動作確認
- [ ] visible_to_user?のパフォーマンス確認
- [ ] 空状態の表示確認
- [ ] ページネーションの動作確認
