---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 17
  claims_with_evidence: 15
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：188-組織設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：15 / 17、根拠なし：2
- 優先レビュー（高）
  1. **組織削除のGraphQL Mutation**：削除処理の詳細を確認
  2. **URL変更時の警告表示**：実装の有無を確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/organizations/settings_controller.rb`
- E-02: `app/controllers/organizations/application_controller.rb`
- E-03: `app/views/organizations/settings/general.html.haml`
- E-04: `app/assets/javascripts/organizations/settings/general/components/app.vue`
- E-05: `app/helpers/organizations/organization_helper.rb`
- E-06: `config/routes/organizations.rb`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが/-/organizations/:organization_path/settings/general | E-06 (行16-18) | ○ |
| C-02 | generalアクションが存在する | E-01 (行9) | ○ |
| C-03 | authorize_admin_organization!が呼ばれる | E-01 (行7) | ○ |
| C-04 | Vue.jsでSPAとして実装 | E-03, E-04 | ○ |
| C-05 | organization_settings_general_app_dataでデータ準備 | E-03 (行5), E-05 (行29-34) | ○ |
| C-06 | 組織情報が含まれる（id, name, path等） | E-05 (行31-32) | ○ |
| C-07 | SearchSettingsコンポーネントを使用 | E-04 (行2, 59-67) | ○ |
| C-08 | 3つのセクションがある | E-04 (行7-9, 69-83) | ○ |
| C-09 | デフォルトでOrganization settingsのみ展開 | E-04 (行19-23) | ○ |
| C-10 | セクション展開状態を管理 | E-04 (行17-24, 31-52) | ○ |
| C-11 | ページタイトルがGeneral settings | E-03 (行2) | ○ |
| C-12 | 機能No.134が組織管理 | E-07 | ○ |
| C-13 | preview_markdown_pathが含まれる | E-05 (行103) | ○ |
| C-14 | organizations_pathが含まれる | E-05 (行104) | ○ |
| C-15 | root_urlが含まれる | E-05 (行105) | ○ |
| C-16 | 組織削除のGraphQL Mutation | **根拠なし**（Mutation要確認） | △ |
| C-17 | URL変更時の警告表示 | **根拠なし**（コンポーネント要確認） | △ |

## 4) 不足情報（Unknown / Missing）
- 組織削除のGraphQL Mutation定義
  - 候補：`app/graphql/mutations/organizations/delete.rb`
- URL変更時の警告表示実装
  - 候補：`app/assets/javascripts/organizations/settings/general/components/change_url.vue`

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - 組織削除は不可逆操作
- 1: 中リスク - URL変更による既存リンクへの影響
- 0: 低リスク - 基本設定変更は影響限定的

## 6) レビュアーチェックリスト（最小）
- [ ] admin_organization権限のスコープ確認
- [ ] 組織削除の確認フロー確認
- [ ] URL変更時の影響範囲確認
- [ ] 可視性レベル変更時のバリデーション確認
