---
generated_at: 2026-01-22 10:53:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：189-プロジェクト編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **REST APIのupdateProjectの詳細**：API仕様を確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/organizations/projects_controller.rb`
- E-02: `app/views/organizations/projects/edit.html.haml`
- E-03: `app/assets/javascripts/organizations/projects/edit/components/app.vue`
- E-04: `app/helpers/organizations/organization_helper.rb`
- E-05: `config/routes/organizations.rb`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが/-/organizations/:organization_path/projects/:namespace_id/:project_id/edit | E-05 (行34-45) | ○ |
| C-02 | editアクションが存在する | E-01 (行9) | ○ |
| C-03 | authorize_project_view_edit_page!が呼ばれる | E-01 (行5, 19-20) | ○ |
| C-04 | Vue.jsでSPAとして実装 | E-02, E-03 | ○ |
| C-05 | organization_projects_edit_app_dataでデータ準備 | E-02 (行5), E-04 (行70-76) | ○ |
| C-06 | プロジェクト情報が含まれる（id, name等） | E-04 (行74) | ○ |
| C-07 | projects_organization_pathが含まれる | E-04 (行72) | ○ |
| C-08 | preview_markdown_pathが含まれる | E-04 (行73) | ○ |
| C-09 | REST APIで更新 | E-03 (行6, 30) | ○ |
| C-10 | serverValidationsでエラー管理 | E-03 (行22, 49-63) | ○ |
| C-11 | 成功メッセージが定義されている | E-03 (行16) | ○ |
| C-12 | エラーメッセージが定義されている | E-03 (行15) | ○ |
| C-13 | ページタイトルがEdit project: {name} | E-02 (行1), E-03 (行14) | ○ |
| C-14 | 機能No.2がプロジェクト編集 | E-06 | ○ |
| C-15 | updateProject REST APIの詳細仕様 | **根拠なし**（API定義要確認） | △ |

## 4) 不足情報（Unknown / Missing）
- `updateProject` REST APIの詳細仕様（パラメータ、レスポンス形式）
  - 候補：`app/assets/javascripts/rest_api.js`、`lib/api/projects.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な編集操作のみ
- 0: 低リスク - 適切な権限チェックが実装されている
- 1: 中リスク - バリデーションエラーのユーザーフィードバック

## 6) レビュアーチェックリスト（最小）
- [ ] view_edit_page権限のスコープ確認
- [ ] REST APIのバリデーションルール確認
- [ ] Markdownプレビューの動作確認
- [ ] キャンセル時のナビゲーション確認
