---
generated_at: 2026-01-22 11:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-プロジェクト探索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/explore/projects/index.html.haml`
- E-02: `app/controllers/explore/projects_controller.rb`
- E-03: `app/finders/projects_finder.rb`
- E-04: `config/routes/explore.rb`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは `/explore/projects` である | E-04 (Line 4) | ○ |
| C-02 | コントローラは Explore::ProjectsController である | E-02 | ○ |
| C-03 | ビューファイルは index.html.haml である | E-01 | ○ |
| C-04 | PageLimiter concernを含む | E-02 (Line 4) | ○ |
| C-05 | MIN_SEARCH_LENGTHは3である | E-02 (Line 11) | ○ |
| C-06 | PAGE_LIMITは50である | E-02 (Line 12) | ○ |
| C-07 | feature_categoryはgroups_and_projectsである | E-02 (Line 30) | ○ |
| C-08 | urgencyはlowである | E-02 (Line 33) | ○ |
| C-09 | explore_projects_vueフラグで条件分岐 | E-02 (Line 19), E-01 (Line 4-5) | ○ |
| C-10 | retire_trending_projectsフラグ対応 | E-02 (Line 20, 50-56) | ○ |
| C-11 | limit_pagesでページ制限を実行 | E-02 (Line 25) | ○ |
| C-12 | HTML/JSON両形式をサポートする | E-02 (Line 39-46) | ○ |
| C-13 | load_projectsメソッドでプロジェクト取得 | E-02 (Line 115-130) | ○ |
| C-14 | ProjectsFinder.newでプロジェクト検索 | E-02 (Line 124), E-03 | ○ |
| C-15 | preload_associationsで関連データ事前読み込み | E-02 (Line 126, 151-154) | ○ |
| C-16 | show_alert_if_search_is_disabledで匿名検索チェック | E-02 (Line 36, 187-194) | ○ |
| C-17 | trendingアクションが存在する | E-02 (Line 49-69), E-04 (Line 9) | ○ |
| C-18 | starredアクションが存在する | E-02 (Line 72-83), E-04 (Line 10) | ○ |
| C-19 | topicsアクションが存在する | E-02 (Line 86-89), E-04 (Line 11) | ○ |
| C-20 | topicアクションが存在する | E-02 (Line 91-106), E-04 (Line 12) | ○ |
| C-21 | current_organizationでフィルタリング | E-02 (Line 121, 196-198) | ○ |
| C-22 | page_canonical_linkが設定される | E-01 (Line 1) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全主張に根拠があり、信頼性が高い
- **1: 中リスク** - Vue.js版（explore_projects_vue）とSSR版の両方が存在するため、どちらが有効か確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] URLパターン `/explore/projects` が正しいか確認
- [ ] explore_projects_vueフラグの状態確認
- [ ] retire_trending_projectsフラグの状態確認
- [ ] 匿名ユーザーの検索機能の動作確認
- [ ] ページネーション制限（50ページ）の動作確認
