---
generated_at: 2026-01-22 10:56:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：190-グループ新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Groups::CreateServiceの詳細実装**：作成処理の詳細を確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/organizations/groups_controller.rb`
- E-02: `app/views/organizations/groups/new.html.haml`
- E-03: `app/assets/javascripts/organizations/groups/new/components/app.vue`
- E-04: `app/assets/javascripts/groups/components/new_edit_form.vue`
- E-05: `app/helpers/organizations/organization_helper.rb`
- E-06: `config/routes/organizations.rb`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが/-/organizations/:organization_path/groups/new | E-06 (行20) | ○ |
| C-02 | newアクションが存在する | E-01 (行15) | ○ |
| C-03 | createアクションが存在する | E-01 (行19-28) | ○ |
| C-04 | authorize_create_group!が呼ばれる | E-01 (行10) | ○ |
| C-05 | Vue.jsでSPAとして実装 | E-02, E-03 | ○ |
| C-06 | organization_groups_new_app_dataでデータ準備 | E-02 (行4), E-05 (行54-58) | ○ |
| C-07 | defaultVisibilityLevelが含まれる | E-05 (行56) | ○ |
| C-08 | basePathが含まれる | E-05 (行119) | ○ |
| C-09 | pathMaxlengthがNamespace::URL_MAX_LENGTH | E-05 (行125) | ○ |
| C-10 | pathPatternがNAMESPACE_FORMAT_REGEX_JS | E-05 (行126) | ○ |
| C-11 | axios.postでグループ作成 | E-03 (行66-72) | ○ |
| C-12 | 成功時にvisitUrlWithAlertsでリダイレクト | E-03 (行74-80) | ○ |
| C-13 | エラー時にcreateAlertで表示 | E-03 (行84) | ○ |
| C-14 | NewEditFormを使用 | E-03 (行6, 108-118), E-04 | ○ |
| C-15 | グループ名からパスを自動生成（slugify） | E-04 (行5, 167-173) | ○ |
| C-16 | ページタイトルがNew group | E-02 (行1), E-03 (行15) | ○ |
| C-17 | Groups::CreateServiceを使用 | E-01 (行64) | ○ |
| C-18 | Groups::CreateServiceの詳細実装 | **根拠なし**（サービスクラス要確認） | △ |

## 4) 不足情報（Unknown / Missing）
- `Groups::CreateService` の詳細な実装とバリデーションルール
  - 候補：`app/services/groups/create_service.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な作成操作のみ
- 0: 低リスク - 適切な権限チェックが実装されている
- 1: 中リスク - パス重複時のエラーハンドリング

## 6) レビュアーチェックリスト（最小）
- [ ] create_group権限のスコープ確認
- [ ] パス形式バリデーションの完全性確認
- [ ] 可視性レベル制限の動作確認
- [ ] 作成成功後のリダイレクト先確認
- [ ] SCIM統合時のピリオド警告の妥当性確認
