---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：191-グループ編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **Vue.jsコンポーネントの詳細実装**：フロントエンド実装の詳細未確認
  2. **フォームデータ項目の完全なリスト**：ヘルパーメソッド内の実装詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/organizations/groups_controller.rb`
- E-02: `app/views/organizations/groups/edit.html.haml`
- E-03: `config/routes/organizations.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パス `/-/organizations/:organization_path/groups/*id/edit` | E-03 (26-31行目) | ○ |
| C-02 | edit アクションは authorize_view_edit_page! で権限チェック | E-01 (12行目) | ○ |
| C-03 | destroy アクションは authorize_remove_group! で権限チェック | E-01 (13行目) | ○ |
| C-04 | 削除スケジュールは Groups::MarkForDeletionService を使用 | E-01 (41行目) | ○ |
| C-05 | 即時削除は Groups::DestroyService.async_execute を使用 | E-01 (80行目) | ○ |
| C-06 | 即時削除は allow_immediate_namespaces_deletion_for_user? で制限 | E-01 (34行目) | ○ |
| C-07 | ビューは #js-organizations-groups-edit マウントポイントを持つ | E-02 (5行目) | ○ |
| C-08 | organization_groups_edit_app_data ヘルパーでデータを渡す | E-02 (5行目) | ○ |
| C-09 | グループ取得は organization.groups から行う | E-01 (59行目) | ○ |
| C-10 | 関連機能No.10「グループ編集」が主機能 | E-04 (248行目) | ○ |
| C-11 | feature_category は :organization | E-01 (7行目) | ○ |
| C-12 | create アクションは Groups::CreateService を使用 | E-01 (64行目) | ○ |
| C-13 | destroy 成功時のメッセージ形式 | E-01 (44-48行目, 81行目) | ○ |
| C-14 | エラー時は 422 status で JSON を返却 | E-01 (26-27行目, 52行目) | ○ |
| C-15 | グループが見つからない場合は render_404 | E-01 (68行目, 74行目) | ○ |
| C-16 | 権限不足の場合は access_denied! | E-01 (70行目, 76行目, 38行目) | ○ |
| C-17 | Vue.jsコンポーネントの入力項目（name, path, description等） | **根拠なし** | △ |
| C-18 | データベース更新対象テーブル（namespaces） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsフロントエンドコンポーネントの実装詳細
  - 候補：`app/assets/javascripts/organizations/groups/edit/` / `ee/app/assets/javascripts/` / フロントエンドテストファイル
- `organization_groups_edit_app_data` ヘルパーメソッドの詳細実装
  - 候補：`app/helpers/organizations/` / `app/helpers/organizations_helper.rb`
- データベーススキーマの直接確認
  - 候補：`db/schema.rb` / `db/structure.sql`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー・ビューの基本構造
- 0: 低リスク - ルーティング設定
- 1: 中リスク - Vue.jsフロントエンドの詳細実装（未確認のため）
- 0: 低リスク - 権限制御ロジック

## 6) レビュアーチェックリスト（最小）
- [ ] フロントエンドコンポーネントの実装を確認し、入出力項目が正確か検証
- [ ] `organization_groups_edit_app_data` ヘルパーの戻り値構造を確認
- [ ] データベース更新仕様が実際のサービスクラス実装と一致するか確認
- [ ] 削除フローの段階的処理（スケジュール→即時）の動作を検証
