---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：192-プロフィール編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **Vue.jsコンポーネント実装**：edit_user_profile_vue フラグ有効時の動作詳細
  2. **データベーススキーマ詳細**：user_details、user_statusesテーブルの完全なカラム一覧

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/user_settings/profiles_controller.rb`
- E-02: `app/views/user_settings/profiles/show.html.haml`
- E-03: `config/routes/user_settings.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パス `/-/user_settings/profile` | E-03 (11行目) | ○ |
| C-02 | GET と PUT メソッドをサポート | E-03 (11行目) | ○ |
| C-03 | Feature Flag `edit_user_profile_vue` で表示切り替え | E-02 (7行目) | ○ |
| C-04 | show アクションでプロフィール表示 | E-01 (17行目) | ○ |
| C-05 | update アクションで Users::UpdateService を呼び出し | E-01 (21行目) | ○ |
| C-06 | check_password: true オプションを使用 | E-01 (21行目) | ○ |
| C-07 | user_params_attributes で許可パラメータを定義 | E-01 (48-81行目) | ○ |
| C-08 | アバター最大サイズ 200KB | E-02 (38行目) | ○ |
| C-09 | アバター推奨サイズ 192x192px | E-02 (37行目) | ○ |
| C-10 | Discord ID は17〜20桁 | E-02 (137-138行目) | ○ |
| C-11 | 自己紹介は最大250文字 | E-02 (119行目) | ○ |
| C-12 | LDAPユーザーは一部フィールドが読み取り専用 | E-02 (72-73行目) | ○ |
| C-13 | タイムゾーンは .js-timezone-dropdown で設定 | E-02 (67行目) | ○ |
| C-14 | ステータスは #js-user-profile-set-status-form で設定 | E-02 (52行目) | ○ |
| C-15 | アバター削除パス profile_avatar_path | E-02 (42行目) | ○ |
| C-16 | Email OTP 変更検証 validate_email_otp_preference_modification | E-01 (95-108行目) | ○ |
| C-17 | 成功メッセージ "Profile was successfully updated" | E-01 (24行目) | ○ |
| C-18 | feature_category :user_profile | E-01 (13行目) | ○ |
| C-19 | skip_before_action :require_email | E-01 (10行目) | ○ |
| C-20 | read_only_attribute? で外部プロバイダ管理を確認 | E-02 (97-100行目, 106-108行目, 113-114行目) | ○ |
| C-21 | データベース更新対象テーブル users | **根拠なし** | △ |
| C-22 | データベース更新対象テーブル user_details, user_statuses | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- `Users::UpdateService` の詳細実装
  - 候補：`app/services/users/update_service.rb`
- Vue.jsコンポーネント（edit_user_profile_vue有効時）の詳細
  - 候補：`app/assets/javascripts/profile/edit/` / `ee/app/assets/javascripts/`
- データベーススキーマの直接確認
  - 候補：`db/schema.rb` / `db/structure.sql`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー・ビューの基本構造
- 0: 低リスク - ルーティング設定
- 0: 低リスク - 入力項目一覧（HAMLから直接確認）
- 1: 中リスク - Vue.js実装詳細（Feature Flag有効時）

## 6) レビュアーチェックリスト（最小）
- [ ] `Users::UpdateService` の実装を確認し、更新処理の詳細を検証
- [ ] Feature Flag `edit_user_profile_vue` 有効時のVue.js実装を確認
- [ ] `user_details` テーブルのスキーマを確認
- [ ] アバターアップロード処理（CarrierWave）の詳細を確認
