---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：193-SSHキー一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **AuthorizedKeysWorker の詳細動作**：authorized_keys ファイル更新処理

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/user_settings/ssh_keys_controller.rb`
- E-02: `app/views/user_settings/ssh_keys/index.html.haml`
- E-03: `app/views/user_settings/ssh_keys/_form.html.haml`
- E-04: `app/views/user_settings/ssh_keys/_key_table.html.haml`
- E-05: `app/models/key.rb`
- E-06: `config/routes/user_settings.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パス `/-/user_settings/ssh_keys` | E-06 (35行目) | ○ |
| C-02 | index アクションで keys を order_id_desc で取得 | E-01 (9行目) | ○ |
| C-03 | create アクションで Keys::CreateService を使用 | E-01 (19行目) | ○ |
| C-04 | destroy アクションで Keys::DestroyService を使用 | E-01 (32行目) | ○ |
| C-05 | revoke アクションで Keys::RevokeService を使用 | E-01 (42行目) | ○ |
| C-06 | key_params で title, key, usage_type, expires_at を許可 | E-01 (53行目) | ○ |
| C-07 | フォームで supported_algorithms を data 属性で渡す | E-03 (8行目) | ○ |
| C-08 | 秘密鍵検出時に警告表示 | E-03 (27-34行目) | ○ |
| C-09 | usage_type は auth_and_signing, auth, signing の enum | E-05 (48-52行目) | ○ |
| C-10 | fingerprint_sha256 の一意性バリデーション | E-05 (38-40行目) | ○ |
| C-11 | generate_fingerprint で MD5 と SHA256 を生成 | E-05 (177-184行目) | ○ |
| C-12 | banned_key バリデーション | E-05 (43行目, 187-199行目) | ○ |
| C-13 | expiration バリデーション | E-05 (42行目, 202-203行目) | ○ |
| C-14 | add_to_authorized_keys コールバック | E-05 (58行目, 117-120行目) | ○ |
| C-15 | remove_from_authorized_keys コールバック | E-05 (59行目, 129-132行目) | ○ |
| C-16 | SystemHooksService で create/destroy フック | E-05 (124-126行目, 144-146行目) | ○ |
| C-17 | キー一覧テーブルのカラム構成 | E-04 (8-14行目) | ○ |
| C-18 | organization_id を登録時に設定 | E-01 (20行目) | ○ |
| C-19 | feature_category :user_profile | E-01 (5行目) | ○ |
| C-20 | authorized_keys ファイル更新処理の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- `AuthorizedKeysWorker` の詳細実装
  - 候補：`app/workers/authorized_keys_worker.rb`
- サービスクラスの詳細実装
  - 候補：`app/services/keys/create_service.rb` / `destroy_service.rb` / `revoke_service.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー・ビューの基本構造
- 0: 低リスク - ルーティング設定
- 0: 低リスク - モデルのバリデーション・コールバック
- 1: 中リスク - authorized_keys ファイル操作（セキュリティ観点）

## 6) レビュアーチェックリスト（最小）
- [ ] `Keys::CreateService` の実装を確認
- [ ] `AuthorizedKeysWorker` の動作を確認
- [ ] 禁止キーリスト（banned keys）の管理方法を確認
- [ ] インスタンス設定による有効期限ポリシーの適用を確認
