---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：194-SSHキー詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/user_settings/ssh_keys_controller.rb`
- E-02: `app/views/user_settings/ssh_keys/show.html.haml`
- E-03: `app/views/user_settings/ssh_keys/_key_details.html.haml`
- E-04: `app/models/key.rb`
- E-05: `config/routes/user_settings.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パス `/-/user_settings/ssh_keys/:id` | E-05 (35行目) | ○ |
| C-02 | show アクションで current_user.keys.find でキー取得 | E-01 (14行目) | ○ |
| C-03 | public_key.weak_key_warning で弱いキー警告を取得 | E-01 (15行目) | ○ |
| C-04 | show.html.haml で _key_details をレンダリング | E-02 (4行目) | ○ |
| C-05 | 弱いキー警告の条件付き表示 | E-03 (3-8行目) | ○ |
| C-06 | PageHeadingComponent でタイトル表示 | E-03 (10行目) | ○ |
| C-07 | 削除ボタンは can_delete? で制御 | E-03 (12行目) | ○ |
| C-08 | 用途タイプ表示 | E-03 (26-27行目) | ○ |
| C-09 | 作成日表示 (created_at.to_fs(:medium)) | E-03 (29行目) | ○ |
| C-10 | 最終使用日表示 (last_used_at) | E-03 (31行目) | ○ |
| C-11 | 有効期限表示（期限切れは赤字） | E-03 (33-40行目) | ○ |
| C-12 | SSH公開鍵の表示とコピーボタン | E-03 (47-50行目) | ○ |
| C-13 | MD5フィンガープリント表示 | E-03 (60行目) | ○ |
| C-14 | SHA256フィンガープリント表示（存在時） | E-03 (61-64行目) | ○ |
| C-15 | fingerprint_md5 は fingerprint のエイリアス | E-04 (61行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー・ビューの基本構造
- 0: 低リスク - 表示項目の一覧

## 6) レビュアーチェックリスト（最小）
- [ ] weak_key_warning の判定ロジックを確認（lib/gitlab/ssh_public_key.rb）
- [ ] FIPSモード時のフィンガープリント表示を確認
