---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：195-GPGキー一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Beyond Identity 連携の詳細**：外部検証フローの詳細実装

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/user_settings/gpg_keys_controller.rb`
- E-02: `app/views/user_settings/gpg_keys/index.html.haml`
- E-03: `app/views/user_settings/gpg_keys/_form.html.haml`
- E-04: `app/views/user_settings/gpg_keys/_key_table.html.haml`
- E-05: `app/models/gpg_key.rb`
- E-06: `config/routes/user_settings.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パス `/-/user_settings/gpg_keys` | E-06 (29行目) | ○ |
| C-02 | index アクションで with_subkeys でサブキー含めて取得 | E-01 (10行目) | ○ |
| C-03 | create アクションで GpgKeys::CreateService を使用 | E-01 (15行目) | ○ |
| C-04 | destroy アクションで GpgKeys::DestroyService を使用 | E-01 (26行目) | ○ |
| C-05 | revoke アクションで @gpg_key.revoke を呼び出し | E-01 (35行目) | ○ |
| C-06 | gpg_key_params で :key のみを許可 | E-01 (46行目) | ○ |
| C-07 | フォームで PGP公開鍵のプレースホルダーを表示 | E-03 (7行目) | ○ |
| C-08 | KEY_PREFIX と KEY_SUFFIX でバリデーション | E-05 (4-5行目, 30-32行目) | ○ |
| C-09 | extract_fingerprint で before_validation | E-05 (49行目, 113-116行目) | ○ |
| C-10 | extract_primary_keyid で before_validation | E-05 (49行目, 119-122行目) | ○ |
| C-11 | generate_subkeys で after_create | E-05 (50行目, 125-130行目) | ○ |
| C-12 | update_invalid_gpg_signatures で after_commit | E-05 (51行目, 93-95行目) | ○ |
| C-13 | revoke メソッドで署名を unknown_key に更新後 destroy | E-05 (97-109行目) | ○ |
| C-14 | emails_with_verified_status でメール検証状態を取得 | E-05 (76-83行目) | ○ |
| C-15 | verified? でメール検証状態を確認 | E-05 (85-87行目) | ○ |
| C-16 | feature_category :source_code_management | E-01 (7行目) | ○ |
| C-17 | Beyond Identity 連携の外部検証チェック | E-04 (2行目) | ○ |
| C-18 | lib/gitlab/gpg.rb での GPG 処理詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- `lib/gitlab/gpg.rb` の詳細実装
  - 候補：`lib/gitlab/gpg.rb` / `lib/gitlab/gpg/` ディレクトリ
- `InvalidGpgSignatureUpdateWorker` の詳細
  - 候補：`app/workers/invalid_gpg_signature_update_worker.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー・ビューの基本構造
- 0: 低リスク - モデルのバリデーション・コールバック
- 1: 中リスク - GPG ライブラリ依存（外部コマンド/ライブラリ）

## 6) レビュアーチェックリスト（最小）
- [ ] `GpgKeys::CreateService` の実装を確認
- [ ] `lib/gitlab/gpg.rb` の GPG 処理を確認
- [ ] `InvalidGpgSignatureUpdateWorker` の動作を確認
- [ ] Beyond Identity 連携（`externally_verified`）の動作を確認
