---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：198-アクセストークン一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Vue.js コンポーネントの詳細実装**：トークン一覧・作成フォームの詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/user_settings/personal_access_tokens_controller.rb`
- E-02: `app/views/user_settings/personal_access_tokens/index.html.haml`
- E-03: `app/models/personal_access_token.rb`
- E-04: `config/routes/user_settings.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パス `/-/user_settings/personal_access_tokens` | E-04 (21行目) | ○ |
| C-02 | POST メソッドで create | E-04 (21行目) | ○ |
| C-03 | PUT `/toggle_dpop` でDPoP切り替え | E-04 (22行目) | ○ |
| C-04 | `.ics` 形式でiCal出力 | E-01 (36-42行目) | ○ |
| C-05 | check_personal_access_tokens_enabled で機能チェック | E-01 (9, 110-112行目) | ○ |
| C-06 | PersonalAccessTokens::CreateService でトークン発行 | E-01 (51-57行目) | ○ |
| C-07 | organization_id を Current.organization.id から取得 | E-01 (54行目) | ○ |
| C-08 | Feature Flag granular_personal_access_tokens でフォーム切り替え | E-02 (7行目) | ○ |
| C-09 | Feature Flag dpop_authentication でDPoP表示制御 | E-02 (12行目) | ○ |
| C-10 | UserPreferences::UpdateService でDPoP設定更新 | E-01 (72行目) | ○ |
| C-11 | expiry_ics でiCalイベント生成 | E-01 (85-99行目) | ○ |
| C-12 | personal_access_token_params で許可パラメータ定義 | E-01 (103行目) | ○ |
| C-13 | PERSONAL_TOKEN_PREFIX = 'glpat-' | E-03 (22行目) | ○ |
| C-14 | MAX_PERSONAL_ACCESS_TOKEN_LIFETIME_IN_DAYS = 365/400 | E-03 (38-39行目) | ○ |
| C-15 | scopes バリデーション | E-03 (96, 195-198行目) | ○ |
| C-16 | expires_at_before_instance_max_expiry_date バリデーション | E-03 (100行目, 221-233行目) | ○ |
| C-17 | feature_category :system_access | E-01 (7行目) | ○ |
| C-18 | Vue.js コンポーネントの入出力項目詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.js コンポーネント実装の詳細
  - 候補：`app/assets/javascripts/access_tokens/` / `ee/app/assets/javascripts/`
- `PersonalAccessTokens::CreateService` の詳細実装
  - 候補：`app/services/personal_access_tokens/create_service.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー・ビューの基本構造
- 0: 低リスク - モデルのバリデーション
- 1: 中リスク - Vue.js コンポーネントの詳細（未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.js トークン一覧コンポーネントの実装を確認
- [ ] `PersonalAccessTokens::CreateService` の実装を確認
- [ ] DPoP 機能の詳細動作を確認
- [ ] iCal 出力のフォーマットを確認
