---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：199-新規アクセストークン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/user_settings/personal_access_tokens_controller.rb`
- E-02: `app/views/user_settings/personal_access_tokens/granular_new.html.haml`
- E-03: `config/routes/user_settings.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パス `/-/user_settings/personal_access_tokens/granular/new` | E-03 (24-25行目) | ○ |
| C-02 | Feature Flag `granular_personal_access_tokens` で制御 | E-01 (47行目) | ○ |
| C-03 | Feature Flag 無効時は render_404 | E-01 (47行目) | ○ |
| C-04 | Vue.js マウントポイント `#js-create-granular-token-app` | E-02 (4行目) | ○ |
| C-05 | personal_access_token_data({}) でデータ渡し | E-02 (4行目) | ○ |
| C-06 | page_title が "Generate fine-grained token" | E-02 (1行目) | ○ |
| C-07 | @hide_search_settings = true | E-02 (2行目) | ○ |
| C-08 | POST は /personal_access_tokens へ送信（create アクション使用） | E-03 (21行目) | ○ |
| C-09 | granular_new アクション定義 | E-01 (46-48行目) | ○ |
| C-10 | ルーティング collection の get 定義 | E-03 (24-25行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（基本的な画面構造は確認済み）
- Vue.js コンポーネントの詳細実装は別途確認推奨

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー・ビューの基本構造
- 0: 低リスク - ルーティング設定

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.js コンポーネント `#js-create-granular-token-app` の実装を確認
- [ ] granular スコープの詳細設定オプションを確認
