---
generated_at: 2026-01-22 11:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：2-パスワードリセット画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **リセットトークンの有効期限**：Devise設定ファイルでの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/devise/passwords/new.html.haml` - パスワードリセット画面ビューテンプレート
- E-02: `app/controllers/passwords_controller.rb` - パスワードコントローラー（1-94行目）
- E-03: `app/models/user.rb` - ユーザーモデル（119行目 devise :recoverable）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（6-7行目）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（3行目）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図（57-59行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/users/password/new` でパスワードリセット画面にアクセス | E-02 (Devise::PasswordsController継承) | ○ |
| C-02 | メールアドレス入力が必須 | E-01 (6行目 required: true) | ○ |
| C-03 | reCAPTCHAが設定時に表示される | E-01 (11-12行目), E-02 (9-10行目) | ○ |
| C-04 | パスワード認証無効時はエラーメッセージを表示 | E-02 (62-67行目) | ○ |
| C-05 | 頻度制限によるスロットリング | E-02 (75-82行目 throttle_reset) | ○ |
| C-06 | プライマリまたは認証済みセカンダリメールが必要 | E-01 (7-8行目 form-text) | ○ |
| C-07 | Sign inリンクが表示される | E-01 (17行目 _sign_in_link) | ○ |
| C-08 | パラノイドモードでメッセージを表示 | E-02 (80-81行目 send_paranoid_instructions) | ○ |
| C-09 | reset_password_tokenが更新される | E-03 (devise :recoverable) | ○ |
| C-10 | reset_password_sent_atが更新される | E-02 (77行目 recently_sent_password_reset?) | ○ |
| C-11 | 関連機能No.78,137が正しくマッピングされている | E-04 (6-7行目) | ○ |
| C-12 | 画面遷移（ログイン画面からの遷移）が正しい | E-06 (57-59行目) | ○ |
| C-13 | POST /users/password でリセット処理が実行される | E-02 (Devise convention) | ○ |
| C-14 | メールアドレスからユーザー検索を行う | E-02 (58-59行目 resource_from_email) | ○ |
| C-15 | reCAPTCHA検証が事前に実行される | E-02 (9行目 prepend_before_action) | ○ |
| C-16 | エラーメッセージ表示領域がある | E-01 (2-3行目 devise-errors) | ○ |
| C-17 | フォームバリデーションが実行される | E-01 (1行目 gl-show-field-errors) | ○ |
| C-18 | リセットトークンの有効期限は6時間 | **根拠なし**（Devise設定ファイル未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- **C-18**: リセットトークンの有効期限（6時間）はDevise設定ファイル（`config/initializers/devise.rb`）で定義されているが、本レビュー時に未確認
  - 候補：`config/initializers/devise.rb` / Devise gem デフォルト設定

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分の主張がソースコードで裏付けられている
- **0（低リスク）**: セキュリティ上重要なパラノイドモードの実装が確認できている

## 6) レビュアーチェックリスト（最小）
- [ ] Devise設定ファイル（`config/initializers/devise.rb`）でリセットトークン有効期限を確認
- [ ] reCAPTCHA設定の有効化状況を確認
- [ ] メール送信設定（SMTPなど）が正しく構成されているか確認
