---
generated_at: 2026-01-22 11:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-グループ探索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/explore/groups/index.html.haml`
- E-02: `app/controllers/explore/groups_controller.rb`
- E-03: `app/finders/groups_finder.rb`
- E-04: `config/routes/explore.rb`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは `/explore/groups` である | E-04 (Line 16) | ○ |
| C-02 | コントローラは Explore::GroupsController である | E-02 | ○ |
| C-03 | ビューファイルは index.html.haml である | E-01 | ○ |
| C-04 | GroupTree concernを含む | E-02 (Line 4) | ○ |
| C-05 | feature_categoryはgroups_and_projectsである | E-02 (Line 6) | ○ |
| C-06 | urgencyはlowである | E-02 (Line 7) | ○ |
| C-07 | MAX_QUERY_SIZEは10,000である | E-02 (Line 9) | ○ |
| C-08 | HTML/JSON両形式をサポートする | E-02 (Line 12-24) | ○ |
| C-09 | explore_groups_vueフラグで条件分岐 | E-02 (Line 14), E-01 (Line 19) | ○ |
| C-10 | render_groupsメソッドでグループ取得 | E-02 (Line 29-31) | ○ |
| C-11 | GroupsFinder.newでグループ検索 | E-02 (Line 30), E-03 | ○ |
| C-12 | render_group_treeでグループツリー表示 | E-02 (Line 30) | ○ |
| C-13 | ページタイトルは "Explore groups" である | E-01 (Line 2) | ○ |
| C-14 | breadcrumb_titleは "Groups" である | E-01 (Line 1) | ○ |
| C-15 | New groupボタンはcan_create_group?で制御 | E-01 (Line 15-17) | ○ |
| C-16 | Pajamas::ButtonComponentが使用されている | E-01 (Line 16) | ○ |
| C-17 | 説明文が表示される | E-01 (Line 12-13) | ○ |
| C-18 | activeパラメータでフィルタ可能 | E-02 (Line 30) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全主張に根拠があり、信頼性が高い
- **1: 中リスク** - Vue.js版（explore_groups_vue）とSSR版の両方が存在するため、どちらが有効か確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] URLパターン `/explore/groups` が正しいか確認
- [ ] explore_groups_vueフラグの状態確認
- [ ] MAX_QUERY_SIZE（10,000件）の制限動作確認
- [ ] New groupボタンの権限制御確認
- [ ] GroupTree concernの動作確認
