---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：200-アクティブセッション一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/user_settings/active_sessions_controller.rb`
- E-02: `app/views/user_settings/active_sessions/index.html.haml`
- E-03: `app/views/user_settings/active_sessions/_active_session.html.haml`
- E-04: `app/models/active_session.rb`
- E-05: `config/routes/user_settings.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パス `/-/user_settings/active_sessions` | E-05 (9行目) | ○ |
| C-02 | DELETE メソッドで destroy | E-05 (9行目) | ○ |
| C-03 | index アクションで `ActiveSession.list(current_user)` 呼び出し | E-01 (8行目) | ○ |
| C-04 | なりすましセッションを `reject(&:is_impersonated)` で除外 | E-01 (8行目) | ○ |
| C-05 | destroy アクションで `ActiveSession.destroy_session` 呼び出し | E-01 (13行目) | ○ |
| C-06 | destroy 後に `invalidate_all_remember_tokens!` 呼び出し | E-01 (14行目) | ○ |
| C-07 | page_title が "Active sessions" | E-02 (1行目) | ○ |
| C-08 | collection でパーシャルをレンダリング | E-02 (11行目) | ○ |
| C-09 | `active_session.current?(session)` で現在セッション判定 | E-03 (1行目) | ○ |
| C-10 | IPアドレス、ブラウザ、OSを表示 | E-03 (9, 19, 21行目) | ○ |
| C-11 | 現在セッションには "This is your current session" 表示 | E-03 (12行目) | ○ |
| C-12 | 非現在セッションにのみ Revoke ボタン表示 | E-03 (32-35行目) | ○ |
| C-13 | 確認ダイアログのメッセージ | E-03 (34行目) | ○ |
| C-14 | ATTR_ACCESSOR_LIST に属性定義 | E-04 (28-33行目) | ○ |
| C-15 | ALLOWED_NUMBER_OF_ACTIVE_SESSIONS = 100 | E-04 (26行目) | ○ |
| C-16 | feature_category :system_access | E-01 (5行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（基本的な画面構造は確認済み）
- `active_sessions_helper.rb` のデバイスアイコン実装は別途確認推奨

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー・ビューの基本構造
- 0: 低リスク - Redisセッション操作
- 0: 低リスク - ルーティング設定

## 6) レビュアーチェックリスト（最小）
- [ ] Redis接続設定（session_store.rb）を確認
- [ ] `invalidate_all_remember_tokens!` の影響範囲を確認
- [ ] デバイスアイコンヘルパーの実装を確認
