---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：201-アイデンティティ追加

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **セッション変数の設定タイミング**：OAuthコールバック処理の詳細が未確認
  2. **extern_uid正規化の詳細仕様**：LDAPプロバイダ以外の正規化処理
  3. **Deviseレイアウトの適用条件**：他のレイアウトとの違い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/user_settings/identities_controller.rb`
- E-02: `app/views/user_settings/identities/new.html.haml`
- E-03: `app/models/identity.rb`
- E-04: `config/routes/user_settings.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは`/-/user_settings/identities/new` | E-04 (13行目) | ○ |
| C-02 | newアクションはGET、createはPOST | E-01 (11行目, 26行目) | ○ |
| C-03 | stateパラメータはセッションと照合される | E-01 (40-42行目) | ○ |
| C-04 | provider, extern_uidはセッションから取得 | E-01 (44-47行目) | ○ |
| C-05 | 既存Identity存在時はアカウント設定画面へリダイレクト | E-01 (18-21行目) | ○ |
| C-06 | 認可成功時に「Authentication method updated」表示 | E-01 (28-29行目) | ○ |
| C-07 | 認可失敗時にエラーメッセージを設定 | E-01 (30-31行目) | ○ |
| C-08 | セッション変数は処理後に削除される | E-01 (33行目, 57-61行目) | ○ |
| C-09 | Deviseレイアウトを使用 | E-01 (23行目) | ○ |
| C-10 | プロバイダラベルはProvider.label_forで取得 | E-02 (2行目) | ○ |
| C-11 | 警告メッセージにユーザー名・メールを表示 | E-02 (12行目) | ○ |
| C-12 | Authorize/Cancelボタンが存在 | E-02 (14-18行目) | ○ |
| C-13 | identitiesテーブルにINSERTされる | E-01 (27行目), E-03 | ○ |
| C-14 | extern_uidは正規化される | E-03 (35-41行目, 45-49行目) | ○ |
| C-15 | state不一致時は403を返す | E-01 (41行目) | ○ |
| C-16 | 関連機能はOAuth2クライアント(89) | E-05 (258行目) | ○ |
| C-17 | feature_categoryはsystem_access | E-01 (5行目) | ○ |
| C-18 | セッション変数設定元はOAuthコールバック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セッション変数（identity_link_state等）を設定するOAuthコールバック処理の実装箇所が未特定
  - 候補：`app/controllers/omniauth_callbacks_controller.rb` / `lib/gitlab/auth/oauth/` / その他認証関連コントローラー

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面表示・フォーム送信の基本フローは明確
- 1: 中リスク - セッション変数の設定元が未確認（連携動作に影響）
- 0: 低リスク - データベース更新仕様は明確

## 6) レビュアーチェックリスト（最小）
- [ ] OAuthコールバックからのセッション変数設定フローを確認
- [ ] state検証のタイミングとセキュリティ要件を確認
- [ ] 既存Identityチェックの挙動（同一プロバイダで異なるextern_uid）を確認
- [ ] エラーメッセージの国際化対応を確認
