---
generated_at: 2026-01-22 12:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：202-アカウント設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **ユーザー名変更のJavaScript処理**：#update-usernameコンポーネントの実装詳細
  2. **アカウント削除モーダルの詳細**：#delete-account-modalの動作
  3. **EE版追加機能**：designated_beneficiariesの詳細仕様

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/profiles/accounts_controller.rb`
- E-02: `app/views/profiles/accounts/show.html.haml`
- E-03: `app/models/user.rb`（部分参照）
- E-04: `app/models/identity.rb`
- E-05: `config/routes/profile.rb`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは`/-/profile/account` | E-05 | ○ |
| C-02 | showアクションで画面表示 | E-01 (10-12行目) | ○ |
| C-03 | LDAPユーザーには警告表示 | E-02 (7-10行目) | ○ |
| C-04 | passkeysフラグで表示分岐 | E-02 (14行目) | ○ |
| C-05 | 2FAステータスはtwo_factor_enabled?で判定 | E-02 (30行目) | ○ |
| C-06 | サポートPINはsupport_pinで取得 | E-02 (43-47行目) | ○ |
| C-07 | PIN生成はUpdateService実行 | E-01 (30-31行目) | ○ |
| C-08 | 外部プロバイダはdisplay_providers_on_profile?で表示判定 | E-02 (59行目) | ○ |
| C-09 | プロバイダ解除はunlinkアクションで処理 | E-01 (14-27行目) | ○ |
| C-10 | プライマリログイン解除は禁止 | E-01 (20-23行目) | ○ |
| C-11 | ユーザー名変更はcan_change_username?で判定 | E-02 (66行目) | ○ |
| C-12 | ユーザー名変更はJSON APIで処理 | E-02 (73行目) | ○ |
| C-13 | パイプラインスケジュールは最大500件 | E-02 (83行目) | ○ |
| C-14 | 削除禁止はprevent_delete_account?で判定 | E-02 (94行目) | ○ |
| C-15 | 唯一のオーナーはcan_be_removed?で判定 | E-02 (105, 107行目) | ○ |
| C-16 | solo_owned_groupsで所有グループ表示 | E-02 (127-132行目) | ○ |
| C-17 | solo_owned_organizationsで所有組織表示 | E-02 (120-125行目) | ○ |
| C-18 | Atlassian連携は専用処理 | E-01 (47行目) | ○ |
| C-19 | feature_categoryはsystem_access | E-01 (7行目) | ○ |
| C-20 | 関連機能はユーザープロファイル(77) | E-06 (259行目) | ○ |
| C-21 | 削除ボタンはid="delete-account-button" | E-02 (114行目) | ○ |
| C-22 | ユーザー名変更コンポーネントのAPIエンドポイント | **一部根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- #update-username JavaScriptコンポーネントの実装ファイルが未特定
  - 候補：`app/assets/javascripts/` / `ee/app/assets/javascripts/` / Vue.jsコンポーネント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サーバーサイド処理は明確
- 1: 中リスク - クライアントサイドコンポーネントの詳細が未確認
- 0: 低リスク - 権限制御の条件は明確

## 6) レビュアーチェックリスト（最小）
- [ ] #update-usernameコンポーネントの実装を確認
- [ ] #delete-account-modalの削除処理フローを確認
- [ ] EE版機能（designated_beneficiaries）の表示条件を確認
- [ ] サポートPINの有効期間設定を確認
