---
generated_at: 2026-01-22 12:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：204-通知設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Vue.jsドロップダウンコンポーネント**：通知レベル選択UIの実装詳細
  2. **EE版メール設定**：notification_emailの詳細仕様
  3. **グループ/プロジェクトパーシャル**：_group_settings、_project_settingsの実装

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/profiles/notifications_controller.rb`
- E-02: `app/views/profiles/notifications/show.html.haml`
- E-03: `app/models/notification_setting.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは`/-/profile/notifications` | E-01 (route参照) | ○ |
| C-02 | showアクションで@user_groups取得 | E-01 (9行目) | ○ |
| C-03 | UserGroupNotificationSettingsFinderで@group_notifications取得 | E-01 (10行目) | ○ |
| C-04 | project_notifications_with_preloaded_associationsで@project_notifications取得 | E-01 (11行目) | ○ |
| C-05 | グローバル通知設定は@global_notification_setting | E-01 (12行目) | ○ |
| C-06 | updateはUsers::UpdateServiceで処理 | E-01 (16行目) | ○ |
| C-07 | user_paramsはnotification_email, notified_of_own_activity | E-01 (27-29行目) | ○ |
| C-08 | グループはページネーション対応 | E-02 (46-47行目) | ○ |
| C-09 | プロジェクト通知設定表示 | E-02 (49-61行目) | ○ |
| C-10 | 通知レベルドロップダウンはVue.js | E-02 (28行目) | ○ |
| C-11 | notified_of_own_activityチェックボックス | E-02 (32行目) | ○ |
| C-12 | NotificationSettingはpolymorphic association | E-03 (10行目) | ○ |
| C-13 | levelのenum定義（global, watch等） | E-03 (7行目) | ○ |
| C-14 | EMAIL_EVENTS定義 | E-03 (38-58行目) | ○ |
| C-15 | feature_categoryはteam_planning | E-01 (4行目) | ○ |
| C-16 | 関連機能は通知設定(83) | E-04 (261行目) | ○ |
| C-17 | グループ未参加時のメッセージ | E-02 (43行目) | ○ |
| C-18 | グループ/プロジェクトパーシャルの詳細 | **一部根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- グループ/プロジェクト設定パーシャル（_group_settings、_project_settings）の詳細実装が未確認
  - 候補：`app/views/profiles/notifications/_group_settings.html.haml` / `_project_settings.html.haml`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー処理は明確
- 1: 中リスク - パーシャルの詳細実装が未確認
- 0: 低リスク - データモデルは明確

## 6) レビュアーチェックリスト（最小）
- [ ] _group_settings.html.hamlの実装を確認
- [ ] _project_settings.html.hamlの実装を確認
- [ ] Vue.js通知ドロップダウンコンポーネントの実装を確認
- [ ] EE版notification_email設定の仕様を確認
