---
generated_at: 2026-01-22 12:20:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：205-2要素認証設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **WebAuthn JavaScript実装**：クライアントサイドのWebAuthn API呼び出し
  2. **パーシャルの詳細**：_otp_registration、_webauthn_registration等の実装
  3. **Passkey機能フラグ**：passkeysフラグの有効条件

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/profiles/two_factor_auths_controller.rb`
- E-02: `app/views/profiles/two_factor_auths/show.html.haml`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは`/-/profile/two_factor_auth` | E-01 (route参照) | ○ |
| C-02 | showアクションで画面表示 | E-01 (20-22行目) | ○ |
| C-03 | createアクションでOTP登録 | E-01 (24-52行目) | ○ |
| C-04 | create_webauthnでWebAuthn登録 | E-01 (55-89行目) | ○ |
| C-05 | codesでリカバリーコード再生成 | E-01 (91-97行目) | ○ |
| C-06 | destroyで2FA無効化 | E-01 (99-109行目) | ○ |
| C-07 | destroy_otpでOTP削除 | E-01 (111-121行目) | ○ |
| C-08 | destroy_webauthnでWebAuthn削除 | E-01 (123-131行目) | ○ |
| C-09 | ValidateManualOtpServiceでPIN検証 | E-01 (25-27行目) | ○ |
| C-10 | 検証成功時にotp_required_for_login更新 | E-01 (33, 38行目) | ○ |
| C-11 | generate_otp_backup_codes!でコード生成 | E-01 (39行目) | ○ |
| C-12 | 他セッション終了（destroy_all_but_current_user_session!） | E-01 (32, 36行目) | ○ |
| C-13 | プライマリメール未確認時リダイレクト | E-01 (266-271行目) | ○ |
| C-14 | validate_current_passwordでパスワード検証 | E-01 (154-171行目) | ○ |
| C-15 | failed_attempts増加 | E-01 (157行目) | ○ |
| C-16 | build_qr_codeでQRコード生成 | E-01 (173-187行目) | ○ |
| C-17 | setup_webauthn_registrationでWebAuthn設定 | E-01 (201-212行目) | ○ |
| C-18 | WebAuthn.Credential.options_for_create使用 | E-01 (235-249行目) | ○ |
| C-19 | passkeysフラグで表示分岐 | E-02 (18行目) | ○ |
| C-20 | 2FAステータスはtwo_factor_enabled?で判定 | E-02 (35行目, 46行目) | ○ |
| C-21 | 通知メール送信 | E-01 (29行目, 68行目) | ○ |
| C-22 | feature_categoryはsystem_access | E-01 (13行目) | ○ |
| C-23 | 関連機能は2要素認証(79) | E-03 (262行目) | ○ |
| C-24 | email_based_mfaフラグでEmail OTP表示 | E-02 (54行目) | ○ |
| C-25 | パーシャルの詳細実装 | **一部根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- 各パーシャル（_otp_registration、_webauthn_registration等）の詳細実装が未確認
  - 候補：`app/views/profiles/two_factor_auths/` 配下のパーシャルファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー処理は詳細に確認済み
- 1: 中リスク - パーシャルおよびJavaScript実装の詳細が未確認
- 0: 低リスク - セキュリティ関連処理（パスワード検証、セッション管理）は明確

## 6) レビュアーチェックリスト（最小）
- [ ] _otp_registration.html.hamlの実装を確認
- [ ] _webauthn_registration.html.hamlの実装を確認
- [ ] WebAuthn JavaScript実装を確認
- [ ] passkeysフラグの有効条件を確認
- [ ] リカバリーコード生成・暗号化ロジックを確認
