---
generated_at: 2026-01-22 12:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：206-リカバリーコード表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **_codes.html.hamlパーシャルの実装**：コード表示UIの詳細
  2. **JavaScriptコピー/ダウンロード機能**：クライアントサイド実装
  3. **コード生成ロジック**：generate_otp_backup_codes!の詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/profiles/two_factor_auths_controller.rb`
- E-02: `app/views/profiles/two_factor_auths/codes.html.haml`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは`/-/profile/two_factor_auth/codes` | E-01 (route参照) | ○ |
| C-02 | codesアクションでコード再生成 | E-01 (91-97行目) | ○ |
| C-03 | generate_otp_backup_codes!でコード生成 | E-01 (93行目) | ○ |
| C-04 | @codesに配列格納 | E-01 (93行目) | ○ |
| C-05 | validate_current_password適用（条件付き） | E-01 (6-8行目) | ○ |
| C-06 | codes.html.hamlがビュー | E-02 | ○ |
| C-07 | _codesパーシャルをレンダリング | E-02 (5行目) | ○ |
| C-08 | ページタイトル設定 | E-02 (1行目) | ○ |
| C-09 | 関連機能は2要素認証(79) | E-03 (263行目) | ○ |
| C-10 | 専用スタイルシート読み込み | E-02 (3行目) | ○ |
| C-11 | show_success_alertパラメータ | E-02 (5行目) | ○ |
| C-12 | _codes.html.hamlの詳細実装 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- _codes.html.hamlパーシャルの詳細実装が未確認
  - 候補：`app/views/profiles/two_factor_auths/_codes.html.haml`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー処理は明確
- 1: 中リスク - パーシャル実装の詳細が未確認
- 0: 低リスク - セキュリティ関連処理は明確

## 6) レビュアーチェックリスト（最小）
- [ ] _codes.html.hamlの実装を確認
- [ ] コードコピー/ダウンロードのJavaScript実装を確認
- [ ] コード生成ロジック（ランダム性、長さ）を確認
