---
generated_at: 2026-01-22 12:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：207-2FA有効化完了

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **Vue.jsコンポーネント実装**：js-2fa-recovery-codesの実際の動作
  2. **passkeysフラグ**：フィーチャーフラグの有効条件
  3. **リカバリーコード生成ロジック**：generate_otp_backup_codes!の詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/profiles/two_factor_auths_controller.rb`
- E-02: `app/views/profiles/two_factor_auths/create.html.haml`
- E-03: `app/views/profiles/two_factor_auths/_codes.html.haml`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | createアクション成功後にレンダリング | E-01 (49行目) | ○ |
| C-02 | create.html.hamlがビュー | E-02 | ○ |
| C-03 | _codesパーシャルをshow_success_alert: trueで呼び出し | E-02 (5行目) | ○ |
| C-04 | ページタイトルは「Two-factor Authentication」 | E-02 (1行目) | ○ |
| C-05 | パンくずリンクはprofile_account_path | E-02 (2行目) | ○ |
| C-06 | 専用スタイルシート読み込み | E-02 (3行目) | ○ |
| C-07 | show_success_alertパラメータをlocal_assignsから取得 | E-03 (1行目) | ○ |
| C-08 | passkeysフラグでリダイレクト先を分岐 | E-03 (2行目) | ○ |
| C-09 | js-2fa-recovery-codesクラスでVue.jsマウント | E-03 (4行目) | ○ |
| C-10 | @codesをJSON形式でdata属性に設定 | E-03 (4行目) | ○ |
| C-11 | redirect_pathをdata属性に設定 | E-03 (4行目) | ○ |
| C-12 | generate_otp_backup_codes!でコード生成 | E-01 (39行目) | ○ |
| C-13 | 関連機能は2要素認証(79) | E-04 (264行目) | ○ |
| C-14 | codes.html.hamlとの違いはshow_success_alertのみ | E-02, E-03 比較 | ○ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsコンポーネント（js-2fa-recovery-codes）の実装詳細
  - 候補：`app/assets/javascripts/`配下のVueコンポーネント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ビューの構造は明確
- 0: 低リスク - パーシャルの実装は完全に確認済み
- 1: 中リスク - Vue.jsコンポーネントの実装詳細は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] js-2fa-recovery-codesのVue.js実装を確認
- [ ] passkeysフラグの有効条件を確認
- [ ] リカバリーコードのコピー/印刷/ダウンロード機能を確認
