---
generated_at: 2026-01-22 12:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：208-メール管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Emails::CreateService**：メール追加サービスの詳細実装
  2. **確認メール送信ロジック**：Deviseとの連携
  3. **3日後自動削除**：バックグラウンドジョブの実装

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/profiles/emails_controller.rb`
- E-02: `app/views/profiles/emails/index.html.haml`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは`/-/profile/emails` | E-01 (route参照) | ○ |
| C-02 | indexアクションで@primary_email取得 | E-01 (16行目) | ○ |
| C-03 | indexアクションで@emails取得 | E-01 (17行目) | ○ |
| C-04 | @show_unconfirmed_emails_alertの条件 | E-01 (21-23行目) | ○ |
| C-05 | createでEmails::CreateService使用 | E-01 (26行目) | ○ |
| C-06 | createでバリデーションエラー表示 | E-01 (27行目) | ○ |
| C-07 | destroyでEmails::DestroyService使用 | E-01 (33行目) | ○ |
| C-08 | resend_confirmation_instructionsでEmails::ConfirmService使用 | E-01 (42行目) | ○ |
| C-09 | profile_add_new_emailレートリミット | E-01 (7-8行目) | ○ |
| C-10 | profile_resend_email_confirmationレートリミット | E-01 (9-10行目) | ○ |
| C-11 | feature_categoryはuser_profile | E-01 (12行目) | ○ |
| C-12 | SettingsSectionComponentでセクション構成 | E-02 (8行目) | ○ |
| C-13 | CrudComponentでメール一覧 | E-02 (17行目) | ○ |
| C-14 | 未確認メール警告はAlertComponentで表示 | E-02 (13行目) | ○ |
| C-15 | プライマリメール表示 | E-02 (37行目) | ○ |
| C-16 | セカンダリメールのループ表示 | E-02 (54行目) | ○ |
| C-17 | 確認メール再送ボタン | E-02 (75-79行目) | ○ |
| C-18 | 削除ボタン | E-02 (81-85行目) | ○ |
| C-19 | 関連機能はメール管理(82) | E-03 (265行目) | ○ |
| C-20 | 未確認メール3日後自動削除 | **実装詳細未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- 未確認メールの3日後自動削除のバックグラウンドジョブ実装が未確認
  - 候補：`app/workers/`配下のWorker

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー処理は明確
- 0: 低リスク - ビューの構造は完全に確認済み
- 1: 中リスク - 自動削除のバックグラウンドジョブ詳細が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] Emails::CreateServiceの実装を確認
- [ ] Emails::ConfirmServiceの実装を確認
- [ ] 未確認メール自動削除のWorkerを確認
- [ ] _email_with_badge.html.hamlの実装を確認
