---
generated_at: 2026-01-22 12:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：209-チャット名管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **_chat_name.html.hamlパーシャル**：行表示の詳細実装
  2. **ChatNameモデル**：暗号化カラムと関連
  3. **削除確認ダイアログ**：UI実装の詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/profiles/chat_names_controller.rb`
- E-02: `app/views/profiles/chat_names/index.html.haml`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは`/-/user_settings/integration_accounts` | E-01 (route参照) | ○ |
| C-02 | indexアクションで@chat_names取得 | E-01 (12行目) | ○ |
| C-03 | destroyでchat_name.destroy実行 | E-01 (44行目) | ○ |
| C-04 | 削除成功時のflash[:notice] | E-01 (45行目) | ○ |
| C-05 | 削除失敗時のflash[:alert] | E-01 (47行目) | ○ |
| C-06 | user_settings_integration_accounts_pathへリダイレクト | E-01 (50行目) | ○ |
| C-07 | feature_categoryはintegrations | E-01 (9行目) | ○ |
| C-08 | SettingsSectionComponentでセクション構成 | E-02 (5行目) | ○ |
| C-09 | CrudComponentで一覧表示 | E-02 (9行目) | ○ |
| C-10 | テーブル形式での一覧表示 | E-02 (14-21行目) | ○ |
| C-11 | render @chat_namesでパーシャル呼び出し | E-02 (23行目) | ○ |
| C-12 | 空時のメッセージ表示 | E-02 (25行目) | ○ |
| C-13 | 関連機能はSlack連携(95) | E-03 (266行目) | ○ |
| C-14 | ページタイトルは「Integration accounts」 | E-02 (1行目) | ○ |
| C-15 | _chat_name.html.hamlパーシャルの詳細 | **未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- _chat_name.html.hamlパーシャルの実装詳細が未確認
  - 候補：`app/views/profiles/chat_names/_chat_name.html.haml`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー処理は明確
- 0: 低リスク - ビューの構造は明確
- 1: 中リスク - パーシャルの詳細実装が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] _chat_name.html.hamlの実装を確認
- [ ] ChatNameモデルのカラム構造を確認
- [ ] 削除確認ダイアログのUI実装を確認
