---
generated_at: 2026-01-22 12:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：210-チャット名追加

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Gitlab::ChatNameToken**：トークン管理クラスの詳細実装
  2. **ChatNameモデルのバリデーション**：保存時の検証ルール
  3. **Slack/Mattermost判定ロジック**：team_id/chat_idの形式

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/profiles/chat_names_controller.rb`
- E-02: `app/views/profiles/chat_names/new.html.haml`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは`/-/user_settings/integration_accounts/new` | E-01 (route参照) | ○ |
| C-02 | newアクションで@integration_name設定 | E-01 (16行目) | ○ |
| C-03 | createでchat_names.new(chat_name_params) | E-01 (20行目) | ○ |
| C-04 | create成功時のflash[:notice] | E-01 (23行目) | ○ |
| C-05 | create失敗時のflash[:alert] | E-01 (25行目) | ○ |
| C-06 | createでdelete_chat_name_token | E-01 (28行目) | ○ |
| C-07 | denyでdelete_chat_name_token | E-01 (34行目) | ○ |
| C-08 | denyでflash[:notice]設定 | E-01 (35-36行目) | ○ |
| C-09 | user_settings_integration_accounts_pathへリダイレクト | E-01 (29, 38行目) | ○ |
| C-10 | chat_name_tokenでトークン検証 | E-01 (63-66行目) | ○ |
| C-11 | chat_name_paramsでパラメータ取得 | E-01 (59-60行目) | ○ |
| C-12 | integration_nameでSlack/Mattermost判定 | E-01 (73-77行目) | ○ |
| C-13 | slack_app_params?でteam_id/chat_id形式判定 | E-01 (79-82行目) | ○ |
| C-14 | feature_categoryはintegrations | E-01 (9行目) | ○ |
| C-15 | CardComponentでUI構成 | E-02 (5行目) | ○ |
| C-16 | タイトルにインテグレーション名とユーザー名 | E-02 (7行目) | ○ |
| C-17 | 権限リストの表示（Issue, Deploy, ChatOps） | E-02 (14-16行目) | ○ |
| C-18 | 再認可不要の説明文 | E-02 (18行目) | ○ |
| C-19 | Authorizeフォーム（POST） | E-02 (21-24行目) | ○ |
| C-20 | Denyフォーム（DELETE） | E-02 (25-28行目) | ○ |
| C-21 | 関連機能はSlack連携(95) | E-03 (267行目) | ○ |
| C-22 | Gitlab::ChatNameTokenの詳細実装 | **未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- Gitlab::ChatNameTokenの詳細実装が未確認
  - 候補：`lib/gitlab/chat_name_token.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー処理は明確
- 0: 低リスク - ビューの構造は完全に確認済み
- 1: 中リスク - トークン管理クラスの詳細が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] Gitlab::ChatNameTokenの実装を確認
- [ ] ChatNameモデルのバリデーションを確認
- [ ] トークン有効期限の仕様を確認
- [ ] Slack/Mattermost判定ロジックの正確性を確認
