---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：211-コメントテンプレート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **GraphQL API仕様**：フロントエンドのGraphQL呼び出し詳細が未確認
  2. **入力項目の最大長**：バリデーション実装の詳細確認が必要
  3. **Vue.jsコンポーネント構造**：フロントエンドの詳細実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/profiles/comment_templates_controller.rb`
- E-02: `app/views/profiles/comment_templates/index.html.haml`
- E-03: `app/views/shared/comment_templates/_page.html.haml`
- E-04: `app/models/users/saved_reply.rb`
- E-05: `config/routes/profile.rb`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はコメントテンプレート管理機能を提供する | E-02, E-03, E-07 | ○ |
| C-02 | URLパスは `/-/profile/comment_templates` | E-05 | ○ |
| C-03 | コントローラーは `Profiles::CommentTemplatesController` | E-01 | ○ |
| C-04 | feature_category は :user_profile | E-01 | ○ |
| C-05 | ビューは shared/comment_templates/page をレンダリング | E-02 | ○ |
| C-06 | Vue.jsアプリケーションとして実装されている | E-03 | ○ |
| C-07 | データは `Users::SavedReply` モデルで管理 | E-04 | ○ |
| C-08 | テーブル名は saved_replies | E-04 | ○ |
| C-09 | user_id を外部キーとして持つ | E-04 | ○ |
| C-10 | ルーティングは index, show のみ | E-05 | ○ |
| C-11 | 機能Noは149（イシュー/MRテンプレート） | E-06 | ○ |
| C-12 | ログインユーザーのみアクセス可能 | E-01 | ○ |
| C-13 | 検索設定を非表示にしている | E-01 | ○ |
| C-14 | base_path パラメータを渡している | E-02, E-03 | ○ |
| C-15 | パーシャルでローディングアイコンを表示 | E-03 | ○ |
| C-16 | GraphQL APIでCRUD操作を行う | **根拠なし** | △ |
| C-17 | 入力項目の最大長は name:255, content:10000 | **根拠なし** | △ |
| C-18 | 確認ダイアログで削除確認を行う | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GraphQL APIの詳細仕様が未確認
  - 候補：`app/graphql/mutations/saved_replies/` / `app/graphql/types/saved_reply_type.rb` / GraphQL schema定義
- Vue.jsコンポーネントの詳細実装が未確認
  - 候補：`app/assets/javascripts/comment_templates/` / Vue components
- バリデーション仕様の詳細確認が必要
  - 候補：`app/models/concerns/saved_reply_concern.rb`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - GraphQL API仕様の未確認により、実際の動作と設計書の記述に乖離がある可能性
- 0: 低リスク - コントローラー・ビュー・ルーティングの基本構造は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] GraphQL mutations/queries の実装を確認
- [ ] Vue.jsコンポーネントの入力バリデーションを確認
- [ ] SavedReplyConcernのバリデーション仕様を確認
- [ ] 削除時の確認ダイアログの有無を確認
