---
generated_at: 2026-01-22 12:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：212-Passkey追加

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **RegisterServiceの詳細仕様**：サービスクラスの実装詳細が未確認
  2. **Vue.jsコンポーネント**：フロントエンドの実装詳細が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/profiles/passkeys_controller.rb`
- E-02: `app/views/profiles/passkeys/new.html.haml`
- E-03: `app/helpers/device_registration_helper.rb`
- E-04: `app/models/webauthn_registration.rb`
- E-05: `config/routes/profile.rb`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はPasskey追加機能を提供する | E-02, E-07 | ○ |
| C-02 | URLパスは `/-/profile/passkeys/new` | E-05 | ○ |
| C-03 | コントローラーは `Profiles::PasskeysController` | E-01 | ○ |
| C-04 | feature_category は :system_access | E-01 | ○ |
| C-05 | Passkeyフィーチャーフラグのチェックを行う | E-01 (行73-74) | ○ |
| C-06 | パスワード検証は条件付きで実行される | E-01 (行10-12, 77-78) | ○ |
| C-07 | WebAuthnRegistrationモデルを使用 | E-04 | ○ |
| C-08 | authentication_mode enumが定義されている | E-04 (行14-17) | ○ |
| C-09 | passkey scopeが定義されている | E-04 (行19) | ○ |
| C-10 | newアクションでイベントトラッキングを行う | E-01 (行19-24) | ○ |
| C-11 | createアクションでRegisterServiceを呼び出す | E-01 (行30-34) | ○ |
| C-12 | 成功時は2FA設定画面へリダイレクト | E-01 (行46) | ○ |
| C-13 | webauthn_xidを初回登録時に設定 | E-01 (行99) | ○ |
| C-14 | WebAuthn::Credential.options_for_createを使用 | E-01 (行120-134) | ○ |
| C-15 | resident_key: 'required'を設定 | E-01 (行130) | ○ |
| C-16 | user_verification: 'required'を設定 | E-01 (行129) | ○ |
| C-17 | セッションにチャレンジを保存 | E-01 (行102) | ○ |
| C-18 | device_registration_dataヘルパーを使用 | E-02, E-03 | ○ |
| C-19 | destroyアクションで他セッションを無効化 | E-01 (行63) | ○ |
| C-20 | ルーティングは new, create, destroy | E-05 (行72) | ○ |
| C-21 | RegisterServiceの詳細実装 | **根拠なし** | △ |
| C-22 | Vue.jsコンポーネントの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- RegisterServiceの詳細実装が未確認
  - 候補：`app/services/authn/passkey/register_service.rb`
- DestroyServiceの詳細実装が未確認
  - 候補：`app/services/authn/passkey/destroy_service.rb`
- Vue.jsコンポーネントの詳細実装が未確認
  - 候補：`app/assets/javascripts/authentication/passkeys/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー・ビュー・モデルの主要構造は確認済み
- 1: 中リスク - サービス層の詳細実装の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] RegisterServiceの実装を確認
- [ ] DestroyServiceの実装を確認
- [ ] Vue.jsコンポーネントの動作を確認
- [ ] WebAuthn APIとの連携を確認
