---
generated_at: 2026-01-22 12:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：213-Slack連携編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **Vue.jsコンポーネントの詳細**：フロントエンドの実装詳細が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/profiles/slacks_controller.rb`
- E-02: `app/views/profiles/slacks/edit.html.haml`
- E-03: `app/helpers/integrations_helper.rb`
- E-04: `config/routes/profile.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はSlack連携設定機能を提供する | E-02, E-06 | ○ |
| C-02 | URLパスは `/-/profile/slack/edit` | E-04 | ○ |
| C-03 | コントローラーは `Profiles::SlacksController` | E-01 | ○ |
| C-04 | feature_category は :integrations | E-01 (行11) | ○ |
| C-05 | 認証をスキップする | E-01 (行7) | ○ |
| C-06 | editアクションでプロジェクト一覧を取得 | E-01 (行13-15) | ○ |
| C-07 | slack_linkアクションでリンクを生成 | E-01 (行17-21) | ○ |
| C-08 | MAINTAINER権限でプロジェクトを絞り込む | E-01 (行28) | ○ |
| C-09 | with_slack_application_disabledスコープを使用 | E-01 (行29) | ○ |
| C-10 | gitlab_slack_application_dataヘルパーを使用 | E-02, E-03 | ○ |
| C-11 | ヘルパーでプロジェクトをJSON化 | E-03 (行248) | ○ |
| C-12 | sign_in_pathをヘルパーで提供 | E-03 (行249) | ○ |
| C-13 | slack_link_pathをヘルパーで提供 | E-03 (行251) | ○ |
| C-14 | GitLabロゴパスを提供 | E-03 (行252) | ○ |
| C-15 | Slackロゴパスを提供 | E-03 (行253) | ○ |
| C-16 | Vue.jsコンポーネントの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsコンポーネントの詳細実装が未確認
  - 候補：`app/assets/javascripts/profile/slack/` / Vue components

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー・ビュー・ヘルパーの主要構造は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsコンポーネントの動作を確認
- [ ] add_to_slack_linkヘルパーの実装を確認
- [ ] Slack認可フローの動作を確認
