---
generated_at: 2026-01-22 12:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：214-使用量クォータ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **Vue.jsコンポーネントの詳細**：フロントエンドの実装詳細が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/profiles/usage_quotas_controller.rb`
- E-02: `app/views/profiles/usage_quotas/index.html.haml`
- E-03: `app/views/shared/usage_quotas/_index.html.haml`
- E-04: `app/helpers/namespaces_helper.rb`
- E-05: `config/routes/profile.rb`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面は使用量クォータ機能を提供する | E-02, E-07 | ○ |
| C-02 | URLパスは `/-/profile/usage_quotas` | E-05 | ○ |
| C-03 | コントローラーは `Profiles::UsageQuotasController` | E-01 | ○ |
| C-04 | feature_category は :consumables_cost_management | E-01 (行7) | ○ |
| C-05 | urgency は :low | E-01 (行8) | ○ |
| C-06 | indexアクションで名前空間を取得 | E-01 (行11-12) | ○ |
| C-07 | 検索設定を非表示にする | E-01 (行11) | ○ |
| C-08 | content_forでタブ内容を定義 | E-02 | ○ |
| C-09 | render_if_existsでEE機能を条件付きレンダリング | E-02 (行5, 8, 10) | ○ |
| C-10 | storage_usage_app_dataヘルパーを使用 | E-02 (行9), E-04 | ○ |
| C-11 | namespace_id, namespace_path等を渡す | E-04 (行97-100) | ○ |
| C-12 | 共有パーシャルをレンダリング | E-02 (行12) | ○ |
| C-13 | ローディング表示を含む | E-03 (行11-13) | ○ |
| C-14 | prepend_modでEE拡張を行う | E-01 (行17) | ○ |
| C-15 | Vue.jsコンポーネントの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsコンポーネントの詳細実装が未確認
  - 候補：`app/assets/javascripts/usage_quotas/` / Vue components

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー・ビュー・ヘルパーの主要構造は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsコンポーネントの動作を確認
- [ ] EE拡張機能（CI/CD分数、Pages）を確認
- [ ] project_statisticsとの連携を確認
