---
generated_at: 2026-01-22 12:20:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：215-ユーザープロフィール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **Vue.jsコンポーネントの詳細**：フロントエンドの実装詳細が未確認
  2. **サイドバーパーシャルの詳細**：`_profile_sidebar.html.haml`の内容未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/users_controller.rb`
- E-02: `app/views/users/show.html.haml`
- E-03: `app/views/users/calendar_activities.html.haml`
- E-04: `app/helpers/users_helper.rb`
- E-05: `config/routes/user.rb`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はユーザープロフィール機能を提供する | E-02, E-07 | ○ |
| C-02 | URLパスは `/:username` | E-05 | ○ |
| C-03 | コントローラーは `UsersController` | E-01 | ○ |
| C-04 | feature_category は :user_profile | E-01 (行48-50) | ○ |
| C-05 | 認証をスキップする | E-01 (行24) | ○ |
| C-06 | showアクションでHTML/Atom/JSON対応 | E-01 (行60-73) | ○ |
| C-07 | profile_actionsでタブを決定 | E-02, E-04 (行40-46) | ○ |
| C-08 | ブロックユーザーはbot判定のみ | E-04 (行43) | ○ |
| C-09 | フィーチャーフラグでVue.js版を切替 | E-02 (行48) | ○ |
| C-10 | user_profile_app_dataでデータを渡す | E-02, E-04 (行224-236) | ○ |
| C-11 | calendarアクションで貢献データ取得 | E-01 (行199-201) | ○ |
| C-12 | calendar_activitiesで日別活動取得 | E-01 (行203-213), E-03 | ○ |
| C-13 | followアクションでフォロー処理 | E-01 (行224-235) | ○ |
| C-14 | unfollowアクションでアンフォロー処理 | E-01 (行238-248) | ○ |
| C-15 | user_profile_actions_dataでアクションデータ | E-04 (行250-266) | ○ |
| C-16 | Schema.org Person対応 | E-02 (行6) | ○ |
| C-17 | Atomフィード対応 | E-02 (行14) | ○ |
| C-18 | ブロックユーザー表示制御 | E-02 (行55-57) | ○ |
| C-19 | プライベートプロフィール表示制御 | E-02 (行59-60) | ○ |
| C-20 | サイドバーを非ブロック時に表示 | E-02 (行61-62) | ○ |
| C-21 | カレンダー活動で日付フォーマット | E-03 (行2) | ○ |
| C-22 | イベント表示のローカライゼーション | E-03 (行5) | ○ |
| C-23 | contributionsカレンダー表示 | E-04 (行228) | ○ |
| C-24 | Vue.jsコンポーネントの詳細実装 | **根拠なし** | △ |
| C-25 | サイドバーパーシャルの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsコンポーネントの詳細実装が未確認
  - 候補：`app/assets/javascripts/profile/` / Vue components
- サイドバーパーシャルの詳細が未確認
  - 候補：`app/views/users/_profile_sidebar.html.haml`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー・ビュー・ヘルパーの主要構造は確認済み
- 1: 中リスク - プライバシー設定による表示制御の詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsコンポーネントの動作を確認
- [ ] サイドバーの表示内容を確認
- [ ] プライバシー設定による表示制御を確認
- [ ] フォロー/アンフォロー処理のエラーハンドリングを確認
