---
generated_at: 2026-01-22 12:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：216-利用規約

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **RespondToTermsServiceの詳細**：サービスクラスの実装詳細が未確認
  2. **Vue.jsコンポーネントの詳細**：フロントエンドの実装詳細が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/users/terms_controller.rb`
- E-02: `app/views/users/terms/index.html.haml`
- E-03: `app/helpers/terms_helper.rb`
- E-04: `app/models/application_setting/term.rb`
- E-05: `config/routes/user.rb`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面は利用規約承認機能を提供する | E-02, E-07 | ○ |
| C-02 | URLパスは `/-/users/terms` | E-05 | ○ |
| C-03 | コントローラーは `Users::TermsController` | E-01 | ○ |
| C-04 | feature_category は :user_management | E-01 (行18) | ○ |
| C-05 | 認証をスキップする | E-01 (行8) | ○ |
| C-06 | enforce_terms!をスキップする | E-01 (行9) | ○ |
| C-07 | check_password_expirationをスキップ | E-01 (行10) | ○ |
| C-08 | check_two_factor_requirementをスキップ | E-01 (行11) | ○ |
| C-09 | require_emailをスキップ | E-01 (行12) | ○ |
| C-10 | termsレイアウトを使用 | E-01 (行16) | ○ |
| C-11 | indexアクションで同意済みチェック | E-01 (行23) | ○ |
| C-12 | acceptアクションで同意処理 | E-01 (行28-38) | ○ |
| C-13 | declineアクションで拒否処理 | E-01 (行40-51) | ○ |
| C-14 | terms_dataヘルパーでデータを渡す | E-02, E-03 | ○ |
| C-15 | accepted_by_user?で同意済み判定 | E-04 (行17-22) | ○ |
| C-16 | プロジェクトボットは自動承認 | E-04 (行18) | ○ |
| C-17 | cache_markdown_fieldを使用 | E-04 (行9) | ○ |
| C-18 | 最新規約をlatest取得 | E-04 (行13-15) | ○ |
| C-19 | RespondToTermsServiceの詳細実装 | **根拠なし** | △ |
| C-20 | Vue.jsコンポーネントの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- RespondToTermsServiceの詳細実装が未確認
  - 候補：`app/services/users/respond_to_terms_service.rb`
- Vue.jsコンポーネントの詳細実装が未確認
  - 候補：`app/assets/javascripts/terms/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー・ビュー・モデルの主要構造は確認済み
- 1: 中リスク - 規約同意フローの全体像確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] RespondToTermsServiceの実装を確認
- [ ] Vue.jsコンポーネントの動作を確認
- [ ] term_agreementsテーブルの構造を確認
- [ ] リダイレクト処理のセキュリティを確認
