---
generated_at: 2026-01-22 12:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：217-通知停止

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/users/unsubscribes_controller.rb`
- E-02: `app/views/users/unsubscribes/show.html.haml`
- E-03: `config/routes/user.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面は通知停止機能を提供する | E-02, E-05 | ○ |
| C-02 | URLパスは `/unsubscribes/:email` | E-03 | ○ |
| C-03 | コントローラーは `Users::UnsubscribesController` | E-01 | ○ |
| C-04 | feature_category は :user_profile | E-01 (行7) | ○ |
| C-05 | 認証をスキップする | E-01 (行5) | ○ |
| C-06 | showアクションでユーザー取得 | E-01 (行9-11) | ○ |
| C-07 | createアクションで購読解除 | E-01 (行13-21) | ○ |
| C-08 | admin_unsubscribe!を呼び出す | E-01 (行17) | ○ |
| C-09 | 完了通知メールを非同期送信 | E-01 (行18) | ○ |
| C-10 | Base64.urlsafe_decode64でデコード | E-01 (行28) | ○ |
| C-11 | User.find_by(email:)で検索 | E-01 (行29) | ○ |
| C-12 | ページタイトルを設定 | E-02 (行1) | ○ |
| C-13 | form_tagでPOST送信 | E-02 (行4) | ○ |
| C-14 | リダイレクト先はログイン画面 | E-01 (行21) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（シンプルな画面のためすべて確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] admin_unsubscribe!メソッドの実装を確認
- [ ] send_unsubscribed_notificationメールテンプレートを確認
- [ ] Base64デコードエラー時の挙動を確認
