---
generated_at: 2026-01-22 12:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：218-カレンダー活動

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/users_controller.rb`
- E-02: `app/views/users/calendar_activities.html.haml`
- E-03: `app/views/events/_event.html.haml`
- E-04: `config/routes/user.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面は特定日の活動詳細を表示する | E-02, E-06 | ○ |
| C-02 | URLパスは `/users/:username/calendar_activities` | E-04 (行98) | ○ |
| C-03 | コントローラーは `UsersController` | E-01 | ○ |
| C-04 | 日付パラメータをパースする | E-01 (行204-207) | ○ |
| C-05 | パースエラー時は当日を使用 | E-01 (行206-207) | ○ |
| C-06 | events_by_dateでイベント取得 | E-01 (行210) | ○ |
| C-07 | Events::RenderServiceで変換 | E-01 (行211) | ○ |
| C-08 | layout: falseでレンダリング | E-01 (行213) | ○ |
| C-09 | 日付見出しを表示 | E-02 (行1-2) | ○ |
| C-10 | イベントをパーシャルで表示 | E-02 (行5) | ○ |
| C-11 | イベントなし時のメッセージ | E-02 (行7-8) | ○ |
| C-12 | タイムゾーン対応の時刻表示 | E-02 (行5), E-03 (行8-10) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（シンプルな部分画面のためすべて確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] contributions_calendar.events_by_dateの実装を確認
- [ ] Events::RenderServiceの処理内容を確認
- [ ] プライベートコントリビューションの表示制御を確認
