---
generated_at: 2026-01-22 12:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：219-ダッシュボード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/dashboard_controller.rb`
- E-02: `app/views/admin/dashboard/index.html.haml`
- E-03: `config/routes/admin.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面は管理者ダッシュボード機能を提供する | E-02, E-05 | ○ |
| C-02 | URLパスは `/admin` | E-03 (行247) | ○ |
| C-03 | コントローラーは `Admin::DashboardController` | E-01 | ○ |
| C-04 | feature_category は :not_owned | E-01 (行10) | ○ |
| C-05 | authorize! :access_admin_area | E-01 (行12) | ○ |
| C-06 | COUNTED_ITEMSで集計対象定義 | E-01 (行8) | ○ |
| C-07 | approximate_countsで概算取得 | E-01 (行15) | ○ |
| C-08 | 最新プロジェクト10件取得 | E-01 (行16) | ○ |
| C-09 | 最新ユーザー10件取得 | E-01 (行17) | ○ |
| C-10 | 最新グループ10件取得 | E-01 (行18) | ○ |
| C-11 | ExternalDatabaseChecker.check | E-01 (行19) | ○ |
| C-12 | KAS情報取得（有効時） | E-01 (行20) | ○ |
| C-13 | Redisバージョン取得 | E-01 (行21) | ○ |
| C-14 | イベントトラッキング設定 | E-02 (行28) | ○ |
| C-15 | CrudComponentでカード表示 | E-02 (行34, 49, 67) | ○ |
| C-16 | feature_entryで機能状態表示 | E-02 (行86-119) | ○ |
| C-17 | コンポーネントバージョン表示 | E-02 (行120-184) | ○ |
| C-18 | KAS情報取得失敗時はUnknown表示 | E-02 (行157) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（主要機能はすべて確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] approximate_countsの精度を確認
- [ ] EE版固有の機能（ライセンス表示等）を確認
- [ ] 各機能状態（feature_entry）の判定ロジックを確認
- [ ] KAS情報取得のエラーハンドリングを確認
