---
generated_at: 2026-01-22 12:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：22-トピック一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **トピックアバターの表示仕様**：具体的な表示ロジックの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/explore/projects/topics.html.haml`
- E-02: `app/controllers/explore/projects_controller.rb`
- E-03: `app/views/shared/topics/_list.html.haml`
- E-04: `config/routes/explore.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | トピック一覧画面のURL `/explore/projects/topics` | E-04 (11行目) | ○ |
| C-02 | コントローラアクション `topics` | E-02 (86-89行目) | ○ |
| C-03 | TopicsFinderを使用したトピック検索 | E-02 (133行目) | ○ |
| C-04 | organization_idによるスコープ | E-02 (135行目) | ○ |
| C-05 | searchパラメータによる検索 | E-02 (134行目) | ○ |
| C-06 | ページネーション（without_count） | E-02 (136行目) | ○ |
| C-07 | Empty Stateの条件分岐 | E-01 (10-11行目) | ○ |
| C-08 | 共有パーシャルを使用したリスト表示 | E-01 (14行目), E-03 | ○ |
| C-09 | トピック詳細への遷移パス | E-04 (12行目) | ○ |
| C-10 | feature_category :groups_and_projects | E-02 (30行目) | ○ |
| C-11 | urgency :low | E-02 (33行目) | ○ |
| C-12 | プロジェクト数のカウント表示 | E-03 (10行目) | ○ |
| C-13 | 関連機能No.102（グローバル検索） | E-05 (32行目) | ○ |
| C-14 | カテゴリ「探索」 | E-06 (23行目) | ○ |
| C-15 | 検索フォームヘッダー | E-01 (13行目) | ○ |
| C-16 | トピックアバターの詳細表示仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- トピックアバター画像の取得・表示ロジックの詳細
  - 候補：`app/views/shared/topics/_topic.html.haml` / `app/models/projects/topic.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URL、ルーティング、基本的なコントローラ処理
- 0: 低リスク - ビューの構造とEmpty State
- 0: 低リスク - ページネーション処理

## 6) レビュアーチェックリスト（最小）
- [ ] TopicsFinderのsearchパラメータによる検索動作を確認
- [ ] organization_idスコープの適用が正しいか確認
- [ ] トピックアバターの表示ロジックを確認
- [ ] Empty Stateの表示条件が正しいか確認
