---
generated_at: 2026-01-22 12:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：220-システム情報

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/system_info_controller.rb`
- E-02: `app/views/admin/system_info/show.html.haml`
- E-03: `config/routes/admin.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はシステム情報表示機能を提供する | E-02, E-05 | ○ |
| C-02 | URLパスは `/admin/system_info` | E-03 (行133) | ○ |
| C-03 | コントローラーは `Admin::SystemInfoController` | E-01 | ○ |
| C-04 | feature_category は :not_owned | E-01 (行4) | ○ |
| C-05 | authorize! :read_admin_system_information | E-01 (行5) | ○ |
| C-06 | EXCLUDED_MOUNT_OPTIONS定義 | E-01 (行7-11) | ○ |
| C-07 | EXCLUDED_MOUNT_TYPES定義 | E-01 (行13-38) | ○ |
| C-08 | Vmstat.cpuでCPU情報取得 | E-01 (行41-45) | ○ |
| C-09 | CPU取得エラー時はnil | E-01 (行43-44) | ○ |
| C-10 | Vmstat.memoryでメモリ情報取得 | E-01 (行46-50) | ○ |
| C-11 | Sys::Filesystem.mountsでマウント取得 | E-01 (行51) | ○ |
| C-12 | ディスク情報をフィルタリング | E-01 (行54-58) | ○ |
| C-13 | イベントトラッキング設定 | E-02 (行4) | ○ |
| C-14 | CardComponentでカード表示 | E-02 (行5, 18, 32, 40) | ○ |
| C-15 | ProgressComponentでプログレスバー | E-02 (行26, 47-50) | ○ |
| C-16 | 起動時刻はRails.application.config.booted_at | E-02 (行37) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（シンプルな情報表示画面のためすべて確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Vmstat gemの動作環境を確認（Linux/macOS対応）
- [ ] Sys::Filesystem gemの動作環境を確認
- [ ] 除外マウントタイプの妥当性を確認
- [ ] number_to_human_sizeのフォーマットを確認
