---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：221-ヘルスチェック画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **ApplicationSettingsテーブルの更新仕様**：トークンリセット処理の実装詳細を確認
  2. **HealthCheck::Utilsの処理詳細**：process_checksメソッドの内部実装

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/health_check_controller.rb`（行1-19）
- E-02: `app/views/admin/health_check/show.html.haml`（行1-42）
- E-03: `config/routes/admin.rb`（行122, 186）
- E-04: `lib/gitlab/health_checks/simple_abstract_check.rb`（行1-50）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行222）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行278）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは/admin/health_checkである | E-03 (行122) | ○ |
| C-02 | showアクションのみ提供される | E-03 (行122) | ○ |
| C-03 | HealthCheck::Utils.process_checksでチェック実行 | E-01 (行9) | ○ |
| C-04 | checksは['standard']を返す | E-01 (行14-16) | ○ |
| C-05 | admin_all_resources権限でトークン表示 | E-02 (行8) | ○ |
| C-06 | readiness_urlが表示される | E-02 (行21) | ○ |
| C-07 | liveness_urlが表示される | E-02 (行23) | ○ |
| C-08 | metrics_urlが表示される | E-02 (行25) | ○ |
| C-09 | トークンリセットURLは/admin/application_settings/reset_health_check_token | E-03 (行186) | ○ |
| C-10 | Healthy/Unhealthy状態表示がある | E-02 (行28-30) | ○ |
| C-11 | read_admin_health_check権限が必要 | E-01 (行6) | ○ |
| C-12 | エラー時は@errorsに格納 | E-01 (行9), E-02 (行41) | ○ |
| C-13 | 確認ダイアログのメッセージ | E-02 (行13) | ○ |
| C-14 | feature_categoryはnot_ownedである | E-01 (行4) | ○ |
| C-15 | 画面遷移図に基づく遷移パターン | E-05, E-06 | ○ |
| C-16 | 機能No.143と関連 | E-06 (行278) | ○ |
| C-17 | application_settingsテーブルのhealth_check_access_tokenが更新される | **根拠なし** | △ |
| C-18 | SecureRandomでトークンが生成される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17, C-18: トークンリセット処理の実装詳細（ApplicationSettingsのコールバックまたはサービスクラス）
  - 候補：`app/models/application_setting.rb` / `app/services/` / `lib/gitlab/current_settings.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UIの表示内容とルーティングは確認済み
- 1: 中リスク - トークンリセット処理の詳細実装は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] トークンリセット処理の実装を確認（ApplicationSettings モデルまたは関連サービス）
- [ ] 権限チェック（admin_all_resources, read_admin_health_check）が正しく記載されているか
- [ ] ヘルスチェックエンドポイント（readiness/liveness/metrics）の仕様が正確か
