---
generated_at: 2026-01-22 12:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：222-バックグラウンドジョブ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全てのClaimに根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/background_jobs_controller.rb`（行1-7）
- E-02: `app/views/admin/background_jobs/show.html.haml`（行1-9）
- E-03: `config/routes/admin.rb`（行123）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行223）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行279）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは/admin/background_jobsである | E-03 (行123) | ○ |
| C-02 | showアクションのみ提供される | E-03 (行123: `only: [:show]`) | ○ |
| C-03 | Admin::ApplicationControllerを継承 | E-01 (行4: `Admin::ApplicationController`を継承する`Admin::BackgroundJobsController`) | ○ |
| C-04 | feature_categoryはnot_ownedである | E-01 (行5) | ○ |
| C-05 | ページタイトルは"Background jobs" | E-02 (行1) | ○ |
| C-06 | Sidekiqへの外部リンクがある | E-02 (行2) | ○ |
| C-07 | iframeでsidekiq_pathを表示 | E-02 (行9) | ○ |
| C-08 | iframe幅は100% | E-02 (行9: `width: '100%'`) | ○ |
| C-09 | iframe高さは970px | E-02 (行9: `height: 970`) | ○ |
| C-10 | iframeのborderは0 | E-02 (行9: `style: "border: 0"`) | ○ |
| C-11 | コントローラに特別な処理はない | E-01 (行1-7: メソッド定義なし) | ○ |
| C-12 | 機能No.117と関連 | E-05 (行279) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 非常にシンプルな画面であり、全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Sidekiq Web UIのマウント設定（/sidekiq）が正しいか確認
- [ ] Admin::ApplicationControllerの認証・認可ロジックが適切か確認
